/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.oldinstallation.internal.impl.resource;

import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.installation.resource.ResourceControllerInfo;
import com.ur.polyscope.oldinstallation.internal.impl.resource.InstallationResourceControlSettings;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import java.util.Collections;
import java.util.Map;

public class InstallationResourceControlSettingsConversionStrategy
implements InstallationComponentConversionStrategy<InstallationResourceControlSettings> {
    public static final String RESOURCE = "Resource";
    public static final String RESOURCE_ID = "ResourceId";
    public static final String CONTROLLER_ID = "ControllerId";
    public static final String CONTROLLER_DISPLAY_NAME = "ControllerDisplayName";
    public static final String CONTROLLER_VENDOR_NAME = "ControllerVendorName";

    public Class<InstallationResourceControlSettings> getSupportedType() {
        return InstallationResourceControlSettings.class;
    }

    public boolean canUnmarshalFrom(PersistReader persistReader) {
        return true;
    }

    public void marshal(InstallationResourceControlSettings resourceControlSettings, PersistWriter persistWriter) {
        for (String resourceId : resourceControlSettings.getResourceIds()) {
            persistWriter.startNode(RESOURCE);
            persistWriter.addAttribute(RESOURCE_ID, resourceId);
            ResourceControllerInfo controllerInfo = resourceControlSettings.getResourceControllerInfo(resourceId);
            persistWriter.addAttribute(CONTROLLER_ID, controllerInfo.getId());
            persistWriter.addAttribute(CONTROLLER_DISPLAY_NAME, controllerInfo.getDisplayName());
            persistWriter.addAttribute(CONTROLLER_VENDOR_NAME, controllerInfo.getVendorName());
            persistWriter.endNode();
        }
    }

    public InstallationResourceControlSettings unmarshal(PersistReader reader) {
        InstallationResourceControlSettings settings = new InstallationResourceControlSettings();
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            String resourceId = reader.getStringAttribute(RESOURCE_ID);
            String controllerId = reader.getStringAttribute(CONTROLLER_ID);
            String displayName = reader.getStringAttribute(CONTROLLER_DISPLAY_NAME);
            String vendorName = reader.getStringAttribute(CONTROLLER_VENDOR_NAME);
            ResourceControllerInfo info = new ResourceControllerInfo(controllerId, displayName, vendorName);
            settings.addResourceControllerInfo(resourceId, info);
            reader.moveToParentNode();
        }
        return settings;
    }

    public Map<String, Class<? extends InstallationResourceControlSettings>> getClassAliases(boolean b) {
        return Collections.singletonMap("ResourceControlSettings", InstallationResourceControlSettings.class);
    }

    public Map<String, Class<? extends InstallationResourceControlSettings>> getTypeAliases(boolean b) {
        return Collections.singletonMap("ResourceControlSettings", InstallationResourceControlSettings.class);
    }
}

