/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urscript;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.ur.polyscope.urscript.CodeLink;
import com.ur.polyscope.urscript.Factor;
import com.ur.polyscope.urscript.Visitor;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"operator", "expr_lhs", "expr_rhs"})
public class Expression
extends CodeLink {
    @JsonProperty(value="operator")
    @NotNull
    private Operator operator;
    @JsonProperty(value="expr_lhs")
    @Valid
    @NotNull
    private Factor exprLhs;
    @JsonProperty(value="expr_rhs")
    @Valid
    private Factor exprRhs;

    @JsonProperty(value="operator")
    public Operator getOperator() {
        return this.operator;
    }

    @JsonProperty(value="operator")
    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @JsonProperty(value="expr_lhs")
    public Factor getExprLhs() {
        return this.exprLhs;
    }

    @JsonProperty(value="expr_lhs")
    public void setExprLhs(Factor exprLhs) {
        this.exprLhs = exprLhs;
    }

    @JsonProperty(value="expr_rhs")
    public Factor getExprRhs() {
        return this.exprRhs;
    }

    @JsonProperty(value="expr_rhs")
    public void setExprRhs(Factor exprRhs) {
        this.exprRhs = exprRhs;
    }

    @Override
    public void traverse(Visitor visitor) {
        visitor.visit(this);
        if (this.getOperator() != null) {
            this.getOperator().traverse(visitor);
        }
        if (this.getExprLhs() != null) {
            this.getExprLhs().traverse(visitor);
        }
        if (this.getExprRhs() != null) {
            this.getExprRhs().traverse(visitor);
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("operator", (Object)this.operator).append("exprLhs", (Object)this.exprLhs).append("exprRhs", (Object)this.exprRhs).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.operator).append((Object)this.exprLhs).append((Object)this.exprRhs).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Expression)) {
            return false;
        }
        Expression rhs = (Expression)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.operator, (Object)rhs.operator).append((Object)this.exprLhs, (Object)rhs.exprLhs).append((Object)this.exprRhs, (Object)rhs.exprRhs).isEquals();
    }

    public static enum Operator {
        OR("or"),
        AND("and"),
        XOR("xor"),
        EQ("eq"),
        NE("ne"),
        GE("ge"),
        LE("le"),
        GT("gt"),
        LT("lt"),
        ADD("add"),
        SUB("sub"),
        MUL("mul"),
        DIV("div"),
        MOD("mod"),
        NOT("not"),
        PLUS("plus"),
        MINUS("minus");

        private final String value;
        private static final Map<String, Operator> CONSTANTS;

        private Operator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Operator fromValue(String value) {
            Operator constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public void traverse(Visitor entity) {
        }

        static {
            CONSTANTS = new HashMap<String, Operator>();
            for (Operator c : Operator.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

