/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urscript;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.ur.polyscope.urscript.CodeLink;
import com.ur.polyscope.urscript.FormalParameters;
import com.ur.polyscope.urscript.Statement;
import com.ur.polyscope.urscript.Visitor;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"identifier", "parameters", "statements"})
public class FunDef
extends CodeLink {
    @JsonProperty(value="identifier")
    @NotNull
    private String identifier;
    @JsonProperty(value="parameters")
    @Valid
    private FormalParameters parameters;
    @JsonProperty(value="statements")
    @Size(min=1)
    @Valid
    @NotNull
    private List<Statement> statements = new ArrayList<Statement>();

    @JsonProperty(value="identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="parameters")
    public FormalParameters getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    public void setParameters(FormalParameters parameters) {
        this.parameters = parameters;
    }

    @JsonProperty(value="statements")
    public List<Statement> getStatements() {
        return this.statements;
    }

    @JsonProperty(value="statements")
    public void setStatements(List<Statement> statements) {
        this.statements = statements;
    }

    @Override
    public void traverse(Visitor visitor) {
        visitor.visit(this);
        if (this.getParameters() != null) {
            this.getParameters().traverse(visitor);
        }
        for (Statement element : this.getStatements()) {
            element.traverse(visitor);
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("identifier", (Object)this.identifier).append("parameters", (Object)this.parameters).append("statements", this.statements).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.identifier).append((Object)this.parameters).append(this.statements).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FunDef)) {
            return false;
        }
        FunDef rhs = (FunDef)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.identifier, (Object)rhs.identifier).append((Object)this.parameters, (Object)rhs.parameters).append(this.statements, rhs.statements).isEquals();
    }
}

