/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urscript;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.ur.polyscope.urscript.CodeLink;
import com.ur.polyscope.urscript.Factor;
import com.ur.polyscope.urscript.Statement;
import com.ur.polyscope.urscript.Visitor;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"condition", "if_statements", "else_statements"})
public class IfStmt
extends CodeLink {
    @JsonProperty(value="condition")
    @Valid
    @NotNull
    private Factor condition;
    @JsonProperty(value="if_statements")
    @Size(min=1)
    @Valid
    @NotNull
    private List<Statement> ifStatements = new ArrayList<Statement>();
    @JsonProperty(value="else_statements")
    @Size(min=0)
    @Valid
    private List<Statement> elseStatements = new ArrayList<Statement>();

    @JsonProperty(value="condition")
    public Factor getCondition() {
        return this.condition;
    }

    @JsonProperty(value="condition")
    public void setCondition(Factor condition) {
        this.condition = condition;
    }

    @JsonProperty(value="if_statements")
    public List<Statement> getIfStatements() {
        return this.ifStatements;
    }

    @JsonProperty(value="if_statements")
    public void setIfStatements(List<Statement> ifStatements) {
        this.ifStatements = ifStatements;
    }

    @JsonProperty(value="else_statements")
    public List<Statement> getElseStatements() {
        return this.elseStatements;
    }

    @JsonProperty(value="else_statements")
    public void setElseStatements(List<Statement> elseStatements) {
        this.elseStatements = elseStatements;
    }

    @Override
    public void traverse(Visitor visitor) {
        visitor.visit(this);
        if (this.getCondition() != null) {
            this.getCondition().traverse(visitor);
        }
        for (Statement element : this.getIfStatements()) {
            element.traverse(visitor);
        }
        for (Statement element : this.getElseStatements()) {
            element.traverse(visitor);
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("condition", (Object)this.condition).append("ifStatements", this.ifStatements).append("elseStatements", this.elseStatements).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.condition).append(this.ifStatements).append(this.elseStatements).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IfStmt)) {
            return false;
        }
        IfStmt rhs = (IfStmt)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.condition, (Object)rhs.condition).append(this.ifStatements, rhs.ifStatements).append(this.elseStatements, rhs.elseStatements).isEquals();
    }
}

