/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urscript;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.ur.polyscope.urscript.CodeLink;
import com.ur.polyscope.urscript.DotOperator;
import com.ur.polyscope.urscript.Factor;
import com.ur.polyscope.urscript.ListIndex;
import com.ur.polyscope.urscript.MatrixIndex;
import com.ur.polyscope.urscript.Visitor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"identifier", "expression"})
public class PointerChain
extends CodeLink {
    @JsonProperty(value="identifier")
    @NotNull
    private String identifier;
    @JsonProperty(value="expression")
    @Valid
    @NotNull
    private Factor expression;
    private Object data;
    @JsonIgnore
    private Type type;

    @JsonProperty(value="identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @JsonProperty(value="expression")
    public Factor getExpression() {
        return this.expression;
    }

    @JsonProperty(value="expression")
    public void setExpression(Factor expression) {
        this.expression = expression;
    }

    @JsonIgnore
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="dot_operator")
    public void setDotOperator(DotOperator dot_operator) {
        this.data = dot_operator;
        this.type = Type.DOT_OPERATOR;
    }

    @JsonProperty(value="dot_operator")
    @Nullable
    public DotOperator getDotOperator() {
        if (!(this.data instanceof DotOperator)) {
            return null;
        }
        return (DotOperator)this.data;
    }

    @JsonProperty(value="matrix_index")
    public void setMatrixIndex(MatrixIndex matrix_index) {
        this.data = matrix_index;
        this.type = Type.MATRIX_INDEX;
    }

    @JsonProperty(value="matrix_index")
    @Nullable
    public MatrixIndex getMatrixIndex() {
        if (!(this.data instanceof MatrixIndex)) {
            return null;
        }
        return (MatrixIndex)this.data;
    }

    @JsonProperty(value="list_index")
    public void setListIndex(ListIndex list_index) {
        this.data = list_index;
        this.type = Type.LIST_INDEX;
    }

    @JsonProperty(value="list_index")
    @Nullable
    public ListIndex getListIndex() {
        if (!(this.data instanceof ListIndex)) {
            return null;
        }
        return (ListIndex)this.data;
    }

    @Override
    public void traverse(Visitor visitor) {
        visitor.visit(this);
        switch (this.type) {
            case DOT_OPERATOR: {
                this.getDotOperator().traverse(visitor);
                break;
            }
            case LIST_INDEX: {
                this.getListIndex().traverse(visitor);
                break;
            }
            case MATRIX_INDEX: {
                this.getMatrixIndex().traverse(visitor);
            }
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("identifier", (Object)this.identifier).append("expression", (Object)this.expression).append("data", this.data).append("type", (Object)this.type).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.identifier).append((Object)this.expression).append(this.data).append((Object)this.type).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PointerChain)) {
            return false;
        }
        PointerChain rhs = (PointerChain)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.identifier, (Object)rhs.identifier).append((Object)this.expression, (Object)rhs.expression).append(this.data, rhs.data).append((Object)this.type, (Object)rhs.type).isEquals();
    }

    public static enum Type {
        DOT_OPERATOR("dot_operator"),
        MATRIX_INDEX("matrix_index"),
        LIST_INDEX("list_index");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public void traverse(Visitor entity) {
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

