/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.AbstractInputPanel;
import com.ur.swing.ApplicationFrameProvider;
import com.ur.swing.CloseListener;
import com.ur.swing.CompletedListener;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.InputPanel;
import com.ur.swing.InputPicker;
import com.ur.swing.ScreenUtils;
import com.ur.swing.dialog.DialogProvider;
import com.ur.swing.validation.ValidationStrategy;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public abstract class AbstractPicker
implements InputPicker {
    private static final DialogProvider DIALOG_PROVIDER = new DialogProvider(new ApplicationFrameProvider());
    private InputPicker.Request activeRequest = InputPicker.Request.Apply;
    private ChangeListener removeOnTabHasChanged;
    protected int visiblePositionY;
    protected AbstractInputPanel keyboardPanel;
    protected JTextComponent textField;
    protected JDialog keyboardDialog;
    protected CompletedListener completedListener = CompletedListener.NULL;
    protected List<CloseListener> closeListeners = new ArrayList<CloseListener>();
    private List<JTabbedPane> panesWithListeners = new ArrayList<JTabbedPane>();

    protected AbstractPicker(final JTextComponent textField) {
        this.textField = textField;
        this.keyboardDialog = DIALOG_PROVIDER.get();
        this.keyboardDialog.setName(this.getName());
        this.keyboardDialog.setResizable(true);
        this.keyboardDialog.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (textField != null && !textField.hasFocus()) {
                    AbstractPicker.this.keyboardDialog.toFront();
                }
            }
        });
        this.keyboardDialog.addWindowFocusListener(new KeyboardSizeWindowListener());
        this.removeOnTabHasChanged = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractPicker.this.hideInputPanel(InputPicker.Request.Cancel);
            }
        };
    }

    @Override
    public final void showInputPanelAt(final JComponent component, int y) {
        this.visiblePositionY = y;
        JTabbedPane pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, component);
        while (pane != null) {
            pane.addChangeListener(this.removeOnTabHasChanged);
            this.panesWithListeners.add(pane);
            pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, pane);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (component != null && component.isEnabled()) {
                    AbstractPicker.this.keyboardPanel.onShow();
                    AbstractPicker.this.onShow();
                }
            }
        });
    }

    @Override
    public void hideInputPanel(InputPicker.Request state) {
        this.removeExistingListeners();
        this.activeRequest = state;
        if (DisplayMessageFactory.hasError(this.textField)) {
            state = InputPicker.Request.Cancel;
        }
        switch (state) {
            case Apply: {
                this.onApply();
                break;
            }
            case Cancel: {
                this.onCancel();
            }
        }
        this.onHide();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenUtils.centerURGUIOnScreen();
                for (CloseListener closeListener : AbstractPicker.this.closeListeners) {
                    closeListener.onClose();
                }
                AbstractPicker.this.onDestroy();
            }
        });
        this.keyboardDialog.setVisible(false);
    }

    private void removeExistingListeners() {
        for (JTabbedPane jTabbedPane : this.panesWithListeners) {
            jTabbedPane.removeChangeListener(this.removeOnTabHasChanged);
        }
        WindowFocusListener[] windowFocusListenerArray = this.keyboardDialog.getWindowFocusListeners();
        int n = windowFocusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WindowFocusListener windowFocusListener = windowFocusListenerArray[n2];
            this.keyboardDialog.removeWindowFocusListener(windowFocusListener);
            ++n2;
        }
    }

    protected void onShow() {
    }

    protected void onApply() {
    }

    private void onHide() {
        if (this.keyboardPanel == null) {
            return;
        }
        this.keyboardPanel.onHide();
    }

    protected void onCancel() {
        this.completedListener.requestCancel();
    }

    protected void onDestroy() {
        if (this.keyboardPanel != null) {
            this.keyboardPanel.onDestroy();
        }
        if (this.textField != null) {
            this.textField.getActionMap().clear();
        }
        JPanel contentPane = (JPanel)this.keyboardDialog.getContentPane();
        contentPane.getActionMap().clear();
        contentPane.getInputMap(2).clear();
        this.removeOnTabHasChanged = null;
        this.panesWithListeners.clear();
        this.closeListeners.clear();
        this.keyboardDialog.dispose();
        this.keyboardPanel = null;
        this.textField = null;
        this.completedListener = CompletedListener.NULL;
    }

    @Override
    public final void setValidationStrategy(ValidationStrategy validationStrategy) {
        this.keyboardPanel.setValidationStrategy(validationStrategy);
    }

    @Override
    public final InputPanel getInputPanel() {
        return this.keyboardPanel;
    }

    @Override
    public final JTextComponent getTextField() {
        return this.textField;
    }

    public void addCompletedListener(CompletedListener completedListener) {
        this.completedListener = completedListener;
    }

    public void addCloseListener(CloseListener closeListener) {
        this.closeListeners.add(closeListener);
    }

    public void addWindowListener(WindowListener windowAdapter) {
        this.keyboardDialog.addWindowListener(windowAdapter);
    }

    private void ensureSelectedTextFieldIsVisible() {
        int keyboardGap = this.calculateKeyboardGap(this.visiblePositionY);
        if (keyboardGap < 0) {
            ScreenUtils.slideURGUIVerticallyFromScreen(keyboardGap);
        }
    }

    private int calculateKeyboardGap(int y) {
        return this.keyboardDialog.getY() - y - 3;
    }

    public boolean isSlideScreenRequired(int y) {
        return this.calculateKeyboardGap(y) < 0;
    }

    public boolean isVisible() {
        return this.keyboardDialog.isVisible();
    }

    public void setActiveRequest(InputPicker.Request activeRequest) {
        this.activeRequest = activeRequest;
    }

    public class KeyboardSizeWindowListener
    implements WindowFocusListener {
        @Override
        public void windowGainedFocus(WindowEvent e) {
            AbstractPicker.this.ensureSelectedTextFieldIsVisible();
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            Window oppositeWin = e.getOppositeWindow();
            if (oppositeWin != null && SwingUtilities.isDescendingFrom(oppositeWin, AbstractPicker.this.keyboardDialog)) {
                return;
            }
            AbstractPicker.this.hideInputPanel(AbstractPicker.this.activeRequest);
        }
    }
}

