/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.lang.Defense;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.BaseView;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.LanguageConfiguration;
import com.ur.swing.ShowScreenAction;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.resources.ImageResource;
import com.ur.util.ArrayUtils;
import com.ur.util.IterableEnumerationWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.jdesktop.swingx.VerticalLayout;

public class AccordionView
extends BaseView {
    private static final Dimension PREFERRED_DIMENSIONS = UIManager.getDimension("AccordionView.dimensions");
    private final transient ViewContext viewContext;
    private final transient WidgetFactory factory;
    private final JPanel content;
    private final Map<AbstractButton, JComponent> completeSet = new HashMap<AbstractButton, JComponent>();
    private final Map<JComponent, ButtonGroup> buttonGroups = new HashMap<JComponent, ButtonGroup>();
    private final ButtonGroup buttonGroup;

    @Inject
    public AccordionView(ViewContext viewContext) {
        this.viewContext = viewContext;
        this.factory = viewContext.createWidgetFactory();
        this.buttonGroup = new ButtonGroup();
        this.content = new JPanel((LayoutManager)new VerticalLayout(1));
        this.buildView();
    }

    private void buildView() {
        this.setMinimumSize(PREFERRED_DIMENSIONS);
        this.setContent(this.content);
    }

    public void setExitAction(Action action) {
        JButton exitButton = this.factory.createButton(action);
        exitButton.setHorizontalAlignment(2);
        exitButton.setPreferredSize(new Dimension(185, 35));
        JPanel header = new JPanel();
        this.viewContext.createToolBarBuilder(header).add(exitButton).toLeft();
        header.setBackground(Color.DARK_GRAY);
        this.setHeader(header);
    }

    public void addShowScreenActionItem(ShowScreenAction action) {
        action.putValue("Function", (Object)ActionDefinition.Function.SECTION_HEADER);
        JToggleButton section = this.factory.createToggleButton(action);
        section.addItemListener(new ShowSelectionMeWhenClicked(action, this.buttonGroup));
        action.putValue("SmallIcon", ImageResource.navigationItemUnselected());
        if (this.content.getComponentCount() == 0) {
            action.putValue("SmallIcon", ImageResource.navigationItemSelected());
            section.setSelected(true);
        }
        this.buttonGroup.add(section);
        this.content.add(section);
    }

    public AbstractButton addSection(String sectionTitle, JComponent subComponent) {
        return this.addSection((Action)new AbstractActionDefinition(sectionTitle){
            {
                this.putValue("Name", string);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }, subComponent);
    }

    public void removeSection(AbstractButton sectionHeader) {
        if (sectionHeader != null) {
            JComponent subComponent = this.completeSet.get(sectionHeader);
            this.content.remove(sectionHeader);
            this.content.remove(subComponent);
            this.completeSet.remove(sectionHeader);
            this.buttonGroup.remove(sectionHeader);
        }
    }

    public AbstractButton addSection(Action action, JComponent subComponent) {
        action.putValue("Function", (Object)ActionDefinition.Function.SECTION_HEADER);
        JToggleButton sectionHeader = this.factory.createToggleButton(action);
        sectionHeader.addItemListener(new CollapseOthersAndShowMeWhenClicked(action, subComponent, this.completeSet, this.buttonGroup));
        action.putValue("SmallIcon", ImageResource.menuCollapse());
        subComponent.setVisible(false);
        if (this.content.getComponentCount() == 0) {
            action.putValue("SmallIcon", ImageResource.menuExpand());
            sectionHeader.setSelected(true);
            subComponent.setVisible(true);
        }
        this.content.add(this.decorateSectionHeader(sectionHeader));
        this.content.add(subComponent);
        this.completeSet.put(sectionHeader, subComponent);
        this.buttonGroup.add(sectionHeader);
        return sectionHeader;
    }

    protected Component decorateSectionHeader(Component sectionHeader) {
        return sectionHeader;
    }

    public AbstractButton addSection(Action sectionAction, Action ... subSectionActions) {
        return this.addSection(sectionAction, (JComponent)this.createPanelOfToggleButtons(this.factory, subSectionActions));
    }

    public AbstractButton addElementToSection(AbstractButton headerButton, Action action) {
        JComponent component = this.completeSet.get(headerButton);
        ButtonGroup sectionButtonGroup = this.buttonGroups.get(component);
        Defense.isInstanceOf((Object)component, JPanel.class);
        Defense.notNull((Object)sectionButtonGroup);
        return this.createSubSectionToggleButton((JPanel)component, sectionButtonGroup, action);
    }

    public void selectSection(FlipManager flippablePanel, ComponentRelation componentRelation) {
        JToggleButton button = this.getSection(componentRelation);
        if (button != null) {
            this.selectButton(button);
            button.getAction().actionPerformed(null);
            Object toSelect = componentRelation.getTargetObject();
            if (toSelect instanceof CardPanel) {
                flippablePanel.switchTo(((CardPanel)toSelect).getClass());
            } else if (toSelect instanceof Action) {
                ((Action)toSelect).actionPerformed(null);
            }
        }
    }

    private void selectButton(AbstractButton button) {
        ItemListener[] itemListenerArray = button.getItemListeners();
        int n = itemListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemListener listener = itemListenerArray[n2];
            listener.itemStateChanged(new ItemEvent(button, 0, null, 1));
            ++n2;
        }
    }

    private JPanel createPanelOfToggleButtons(WidgetFactory factory, Action ... actions) {
        JPanel result = factory.verticalPanel(new JComponent[0]);
        ButtonGroup group = new ButtonGroup();
        for (Action each : ArrayUtils.filter((Object[])actions, Action.class)) {
            this.createSubSectionToggleButton(result, group, each);
        }
        this.buttonGroups.put(result, group);
        return result;
    }

    private AbstractButton createSubSectionToggleButton(JPanel result, ButtonGroup group, Action each) {
        each.putValue("Function", (Object)ActionDefinition.Function.SUB_SECTION_HEADER);
        JToggleButton button = this.decorateSubSection(this.factory.createToggleButton(each));
        if (this.completeSet.isEmpty() && group.getButtonCount() == 0) {
            button.setSelected(true);
        }
        result.add(button);
        group.add(button);
        return button;
    }

    protected <B extends AbstractButton> B decorateSubSection(B button) {
        if (Locale.getDefault() != LanguageConfiguration.SupportedLanguage.en.getLocale()) {
            button.setFont(this.viewContext.getFontFactory().getRelativeFont(URFontFactory.Size.MEDIUM));
        }
        button.setHorizontalTextPosition(2);
        button.setHorizontalAlignment(2);
        return button;
    }

    private JToggleButton getSection(ComponentRelation componentRelation) {
        Enumeration<AbstractButton> sections = this.buttonGroup.getElements();
        while (sections.hasMoreElements()) {
            JToggleButton section = (JToggleButton)sections.nextElement();
            ItemListener[] itemListenerArray = section.getItemListeners();
            int n = itemListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemListener listener = itemListenerArray[n2];
                if (listener instanceof CollapseOthersAndShowMeWhenClicked && ((CollapseOthersAndShowMeWhenClicked)listener).hasRelation(componentRelation) || listener instanceof ShowSelectionMeWhenClicked && ((ShowSelectionMeWhenClicked)listener).isRelated(componentRelation)) {
                    return section;
                }
                ++n2;
            }
        }
        return null;
    }

    public void resetNavigation() {
        AbstractButton firstSectionButton = this.buttonGroup.getElements().nextElement();
        this.selectTopSection(firstSectionButton);
    }

    public void selectTopSection(AbstractButton section) {
        MouseEvent emulatedEvent = new MouseEvent(section, 501, System.currentTimeMillis(), 0, 0, 0, 1, false);
        MouseListener[] mouseListenerArray = section.getMouseListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener each = mouseListenerArray[n2];
            each.mousePressed(emulatedEvent);
            ++n2;
        }
        section.doClick();
        section.getAction().actionPerformed(null);
    }

    public Action getSelected() {
        for (JComponent each : this.completeSet.values()) {
            Action action;
            if (!each.isVisible() || (action = this.findSelectedAction(each)) == null) continue;
            return action;
        }
        return null;
    }

    private Action findSelectedAction(JComponent component) {
        if (component instanceof JPanel) {
            Component[] componentArray = component.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component each = componentArray[n2];
                if (each.isVisible() && each instanceof AbstractButton) {
                    return this.findSelectedAction((AbstractButton)each);
                }
                ++n2;
            }
        }
        if (component instanceof AbstractButton) {
            return this.findSelectedAction((AbstractButton)component);
        }
        return null;
    }

    private Action findSelectedAction(AbstractButton button) {
        if (button.isSelected()) {
            return button.getAction();
        }
        return null;
    }

    public List<AbstractButton> getTopSections() {
        ArrayList<AbstractButton> sections = new ArrayList<AbstractButton>();
        Enumeration<AbstractButton> sectionEnumeration = this.buttonGroup.getElements();
        while (sectionEnumeration.hasMoreElements()) {
            sections.add(sectionEnumeration.nextElement());
        }
        return Collections.unmodifiableList(sections);
    }

    public static class CollapseOthersAndShowMeWhenClicked
    implements ItemListener {
        private final Action action;
        private final JComponent toShow;
        private final Map<AbstractButton, JComponent> completeSet;
        private final ButtonGroup buttonGroup;

        CollapseOthersAndShowMeWhenClicked(Action action, JComponent toShow, Map<AbstractButton, JComponent> completeSet, ButtonGroup buttonGroup) {
            this.action = action;
            this.toShow = toShow;
            this.completeSet = completeSet;
            this.buttonGroup = buttonGroup;
        }

        public JComponent getComponent() {
            return this.toShow;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!this.toShow.isVisible()) {
                for (JComponent each : this.completeSet.values()) {
                    each.setVisible(false);
                }
                for (JComponent each : new IterableEnumerationWrapper(this.buttonGroup.getElements())) {
                    ((AbstractButton)each).getAction().putValue("SmallIcon", ImageResource.menuCollapse());
                }
                this.toShow.setVisible(true);
                this.action.putValue("SwingSelectedKey", true);
                this.action.putValue("SmallIcon", ImageResource.menuExpand());
            }
        }

        boolean hasRelation(ComponentRelation componentRelation) {
            JPanel container = (JPanel)this.getComponent();
            Component[] componentArray = container.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                if (componentRelation.sameLeaf(component)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static interface ComponentRelation {
        public Object getTargetObject();

        public boolean sameLeaf(Component var1);
    }

    public static class ShowSelectionMeWhenClicked
    implements ItemListener {
        private final ShowScreenAction action;
        private final ButtonGroup buttonGroup;

        ShowSelectionMeWhenClicked(ShowScreenAction action, ButtonGroup buttonGroup) {
            this.action = action;
            this.buttonGroup = buttonGroup;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            for (AbstractButton each : new IterableEnumerationWrapper(this.buttonGroup.getElements())) {
                each.getAction().putValue("SmallIcon", ImageResource.navigationItemUnselected());
            }
            this.action.putValue("SwingSelectedKey", true);
            this.action.putValue("SmallIcon", ImageResource.navigationItemSelected());
        }

        boolean isRelated(ComponentRelation componentRelation) {
            Class<? extends CardPanel> panelType = this.action.getDestinationPanelType();
            return panelType.equals(componentRelation.getTargetObject());
        }
    }
}

