/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.injection.ServicesBinder;
import com.ur.swing.FontFactory;
import com.ur.swing.Skin;
import com.ur.swing.g5.G5Skin;
import com.ur.swing.internal.ServicesBinderImpl;
import com.ur.util.logging.Log;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private ServiceRegistration registration;

    public void start(BundleContext bundleContext) {
        Skin skin = Activator.getSkin();
        Activator.tryLoadLookAndFeel(skin.getLookAndFeel());
        this.registration = bundleContext.registerService(ServicesBinder.class, (Object)new ServicesBinderImpl(skin), null);
    }

    private static void tryLoadLookAndFeel(LookAndFeel lookAndFeel) {
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (UnsupportedLookAndFeelException x) {
            Log.error((String)"Error loading look and feel extension: ", (Throwable)x);
        }
    }

    private static Skin getSkin() {
        return new G5Skin(new FontFactory());
    }

    public void stop(BundleContext bundleContext) {
        this.registration.unregister();
    }
}

