/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.lang.Defense;
import com.ur.swing.ComponentView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class BaseView
extends JPanel
implements ComponentView {
    private Color headerBackground;
    private Color headerForeground;
    private Color footerBackground;
    private Color footerForeground;
    private JComponent header;
    private JComponent content;
    private JComponent footer;

    public BaseView() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void setHeader(JComponent panel) {
        Defense.notNull((Object)panel, (String)"Header must NOT be null");
        if (this.header != null) {
            this.remove(this.header);
        }
        this.header = panel;
        this.header.setBackground(this.headerBackground == null ? this.getBackground() : this.headerBackground);
        this.header.setForeground(this.headerForeground == null ? this.getForeground() : this.headerForeground);
        this.add((Component)this.header, "North");
    }

    public void setContent(JComponent content) {
        Defense.notNull((Object)content, (String)"Content must NOT be null");
        if (this.content != null) {
            this.remove(this.content);
        }
        this.content = content;
        this.content.setBackground(this.getBackground());
        this.add((Component)content, "Center");
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
    }

    @Override
    public void setFooter(JComponent panel) {
        Defense.notNull((Object)panel, (String)"Footer must NOT be null");
        if (this.footer != null) {
            this.remove(this.footer);
        }
        this.footer = panel;
        this.footer.setForeground(this.footerForeground == null ? this.getForeground() : this.footerForeground);
        this.footer.setBackground(this.footerBackground == null ? this.getBackground() : this.footerBackground);
        this.add((Component)panel, "South");
    }

    @Override
    public void setBackground(Color bg) {
        if (this.header != null) {
            this.header.setBackground(this.headerBackground == null ? bg : this.headerBackground);
        }
        if (this.content != null) {
            this.content.setBackground(bg);
        }
        if (this.footer != null) {
            this.footer.setBackground(this.footerBackground == null ? bg : this.footerBackground);
        }
        super.setBackground(bg);
    }

    public void setHeaderBackground(Color headerBackground) {
        this.headerBackground = headerBackground;
        if (this.header != null) {
            this.header.setBackground(headerBackground);
        }
    }

    public void setHeaderForeground(Color headerForeground) {
        this.headerForeground = headerForeground;
        if (this.header != null) {
            this.header.setForeground(headerForeground);
        }
    }

    public void setFooterBackground(Color footerBackground) {
        this.footerBackground = footerBackground;
        if (this.footer != null) {
            this.footer.setBackground(footerBackground);
        }
    }

    public void setFooterForeground(Color footerForeground) {
        this.footerForeground = footerForeground;
        if (this.footer != null) {
            this.footer.setForeground(footerForeground);
        }
    }
}

