/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.BundleClassAuthorizer;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Singleton;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;

@Singleton
public final class BundleClassAuthorizerImpl
implements BundleClassAuthorizer {
    private final Set<String> deniedClassNames = new HashSet<String>();

    @Override
    public synchronized void denyClassesIn(BundleContext bundleContext, Set<Class> contributedServices) throws InvalidSyntaxException {
        Set<Bundle> urcapBundles = this.getURCapBundles(bundleContext, contributedServices);
        Set<String> dcn = this.getDeniedClassNames(urcapBundles);
        this.deniedClassNames.addAll(dcn);
    }

    @Override
    public synchronized boolean isAuthorized(String className) {
        return !this.deniedClassNames.contains(className);
    }

    private Set<Bundle> getURCapBundles(BundleContext context, Set<Class> contributions) throws InvalidSyntaxException {
        HashSet<Bundle> urcapBundles = new HashSet<Bundle>();
        for (Class contribution : contributions) {
            for (Object ref : context.getServiceReferences(contribution, null)) {
                urcapBundles.add(((ServiceReference)ref).getBundle());
            }
        }
        return urcapBundles;
    }

    private Set<String> getDeniedClassNames(Set<Bundle> urcapBundles) {
        HashSet<String> classNames = new HashSet<String>();
        for (Bundle bundle : urcapBundles) {
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            List urcapClassEntries = wiring.findEntries("/", "*.class", 1);
            classNames.addAll(this.getClassNames(urcapClassEntries));
        }
        return classNames;
    }

    private Set<String> getClassNames(List<URL> urcapClassEntries) {
        HashSet<String> classNames = new HashSet<String>();
        for (URL urcapClassEntry : urcapClassEntries) {
            String urcapClass = this.convertToClassName(urcapClassEntry.getPath());
            classNames.add(urcapClass);
        }
        return classNames;
    }

    private String convertToClassName(String classPath) {
        String replaceWithDot = classPath.replace("/", ".");
        return replaceWithDot.substring(1, replaceWithDot.lastIndexOf(".class"));
    }
}

