/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class ButtonLongPressDelegate
implements ActionListener {
    private static int DEFAULT_LONG_PRESS_ACTION_DELAY = 50;
    private static int DEFAULT_INITIAL_LONG_PRESS_ACTION_DELAY = 500;
    private Timer timer;

    public ButtonLongPressDelegate(JButton button, int longPressActionDelayMS, int initialLongPressActionDelayMS) {
        this.createTimer(initialLongPressActionDelayMS, longPressActionDelayMS);
        this.setButtonListener(button);
    }

    public ButtonLongPressDelegate(JButton button) {
        this.createTimer(DEFAULT_INITIAL_LONG_PRESS_ACTION_DELAY, DEFAULT_LONG_PRESS_ACTION_DELAY);
        this.setButtonListener(button);
    }

    private void createTimer(int initialDelay, int delay) {
        this.timer = new Timer(delay, this);
        this.timer.setInitialDelay(initialDelay);
    }

    private void setButtonListener(JButton button) {
        button.addChangeListener(new ButtonModelListener(button));
    }

    private void startContinousAction() {
        if (!this.timer.isRunning()) {
            this.longPressAction();
            this.timer.start();
        }
    }

    private void stopContinousAction() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    protected abstract void longPressAction();

    protected abstract void buttonReleased();

    @Override
    public void actionPerformed(ActionEvent e) {
        this.longPressAction();
    }

    private class ButtonModelListener
    implements ChangeListener {
        private final JButton button;
        private boolean isPressed = false;

        public ButtonModelListener(JButton button) {
            this.button = button;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.button.getModel().isPressed() != this.isPressed) {
                this.isPressed = this.button.getModel().isPressed();
                this.buttonPressChanged();
            }
        }

        private void buttonPressChanged() {
            if (this.isPressed) {
                ButtonLongPressDelegate.this.startContinousAction();
            } else {
                ButtonLongPressDelegate.this.stopContinousAction();
                ButtonLongPressDelegate.this.buttonReleased();
            }
        }
    }
}

