/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.lang.Defense;
import com.ur.swing.CardPanelListener;
import com.ur.swing.CardPanelLogger;
import com.ur.swing.FlipManager;
import com.ur.swing.SwingUtil;
import com.ur.swing.Veto;
import com.ur.swing.card.EnterExitCard;
import com.ur.swing.card.SetFlipManager;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CardPanel
extends JPanel
implements SetFlipManager,
EnterExitCard {
    private static CardPanel currentPanel = null;
    private Object dataObject;
    protected FlipManager flipManager;
    private final List<Veto> vetoSet = new CopyOnWriteArrayList<Veto>();
    private final List<CardPanelListener> cardPanelListeners = new CopyOnWriteArrayList<CardPanelListener>();
    private final Set<FlipManager> flipManagerChildrenSet = new HashSet<FlipManager>();

    public static CardPanel getCurrentPanel() {
        return currentPanel;
    }

    public CardPanel() {
        CardPanelLogger.constructPanel(this);
    }

    @Override
    public void setFlipManager(FlipManager flipManager) {
        Defense.notNull((Object)flipManager, (String)"Supplied FlipManager is null!");
        this.flipManager = flipManager;
    }

    public FlipManager getFlipManager() {
        return this.flipManager;
    }

    public void addVetoOnExitWhen(Veto vetoOnExit) {
        this.vetoSet.add(vetoOnExit);
    }

    public final void setCurrentPanel() {
        currentPanel = this;
    }

    @Override
    public void enter(Object o) {
        CardPanelLogger.enterPanel(this);
        this.setCurrentPanel();
        this.dataObject = o;
        for (CardPanelListener each : this.cardPanelListeners) {
            each.onEnter();
        }
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public void resetAll() {
        for (FlipManager fl : this.flipManagerChildrenSet) {
            fl.resetAll();
        }
    }

    public boolean canReset() {
        for (FlipManager fl : this.flipManagerChildrenSet) {
            if (fl.canReset()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object exit() {
        CardPanelLogger.exitPanel(this);
        for (CardPanelListener each : this.cardPanelListeners) {
            each.onExit();
        }
        return null;
    }

    public boolean switchTo(Class<? extends CardPanel> c, Object o) {
        return this.flipManager.switchTo(c, o);
    }

    public boolean switchTo(Class<? extends CardPanel> c) {
        return this.switchTo(c, null);
    }

    public boolean stackCurrentCardAndSwitchTo(Class<? extends CardPanel> c, Object o) {
        return this.flipManager.stackCurrentCardAndSwitchTo(c, o);
    }

    public boolean stackCurrentCardAndSwitchTo(Class<? extends CardPanel> c) {
        return this.stackCurrentCardAndSwitchTo(c, null);
    }

    public boolean isAllowedToExit() {
        if (!this.isShowing()) {
            return true;
        }
        for (Veto each : this.vetoSet) {
            if (!each.isVetoed()) continue;
            return false;
        }
        return true;
    }

    public void navigateBack() {
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CardPanel.this.flipManager.navigateBack();
            }
        });
    }

    public void addChild(FlipManager fl) {
        this.flipManagerChildrenSet.add(fl);
    }

    public <T extends CardPanel> T getCardPanel(Class<T> panClass) {
        return this.flipManager.getCardPanel(panClass);
    }

    protected void configureTitle(Font font, JPanel panel) {
        panel.setAlignmentX(0.5f);
        panel.setAlignmentY(0.5f);
        Component component = panel.getComponent(0);
        if (panel.getLayout() instanceof FlowLayout) {
            ((FlowLayout)panel.getLayout()).setHgap(-5);
            ((FlowLayout)panel.getLayout()).setVgap(-5);
        }
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            label.setFont(font);
            label.setHorizontalAlignment(0);
            label.setHorizontalTextPosition(0);
            label.setFocusable(false);
        }
    }

    public void addCardPanelListener(CardPanelListener listener) {
        if (!this.cardPanelListeners.contains(listener)) {
            this.cardPanelListeners.add(listener);
        }
    }

    public void removeCardPanelListener(CardPanelListener listener) {
        this.cardPanelListeners.remove(listener);
    }
}

