/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.CardPanel;
import com.ur.util.logging.Log;
import java.util.HashMap;
import java.util.Map;

final class CardPanelLogger {
    private static final FrequencyCounter enterExitCounter = new FrequencyCounter();
    private static final FrequencyCounter constructorCounter = new FrequencyCounter();

    private CardPanelLogger() {
    }

    private static void addLogEntry(String message) {
        Log.debug((String)message);
    }

    static void constructPanel(CardPanel cardPanel) {
        Class<?> c = cardPanel.getClass();
        CardPanelLogger.addLogEntry("Create CardPanel: " + c.getSimpleName() + ", count: " + constructorCounter.add(c));
    }

    static void enterPanel(CardPanel cardPanel) {
        Class<?> c = cardPanel.getClass();
        CardPanelLogger.addLogEntry("Enter CardPanel: " + c.getSimpleName() + ", count: " + enterExitCounter.add(c));
    }

    static void exitPanel(CardPanel cardPanel) {
        Class<?> c = cardPanel.getClass();
        CardPanelLogger.addLogEntry("Exit CardPanel: " + c.getSimpleName() + ", count: " + enterExitCounter.remove(c));
    }

    private static class FrequencyCounter {
        private final Map<Object, Integer> map = new HashMap<Object, Integer>();

        private FrequencyCounter() {
        }

        public int add(Object o) {
            if (!this.map.containsKey(o)) {
                this.map.put(o, 0);
            }
            int val = this.map.get(o);
            this.map.put(o, ++val);
            return val;
        }

        public int remove(Object o) {
            if (!this.map.containsKey(o)) {
                return -1;
            }
            int val = this.map.get(o);
            this.map.put(o, --val);
            return val;
        }
    }
}

