/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.lang.StringUtils;
import com.ur.swing.ComboBoxPopupListener;
import com.ur.swing.ComponentErrorable;
import com.ur.swing.DisplayMessageFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class ComboBox<T>
extends JComboBox<T>
implements ComponentErrorable {
    private static final int MAXIMUM_ROW_COUNT = 9;
    private String errorMessage;
    private String warningMessage;

    public ComboBox() {
        this(new DefaultComboBoxModel());
    }

    public ComboBox(ComboBoxModel<T> comboBoxModel) {
        super(comboBoxModel);
        this.initComboBox();
    }

    private void initComboBox() {
        this.addPopupMenuListener(new ComboBoxPopupListener());
        this.setMaximumRowCount(9);
    }

    @Override
    public boolean hasError() {
        return !StringUtils.isNullOrEmpty((String)this.errorMessage);
    }

    @Override
    public void setError(String message) {
        this.errorMessage = message;
        DisplayMessageFactory.error(this, this.errorMessage);
    }

    public String getError() {
        return this.errorMessage;
    }

    @Override
    public void clearError() {
        this.errorMessage = null;
    }

    @Override
    public boolean hasWarning() {
        return !StringUtils.isNullOrEmpty((String)this.warningMessage);
    }

    @Override
    public void setWarning(String message) {
        this.warningMessage = message;
        DisplayMessageFactory.error(this, this.warningMessage);
    }

    @Override
    public void clearWarning() {
        this.warningMessage = null;
    }
}

