/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboPopup;

public class ComboBoxPopupListener
implements PopupMenuListener {
    private static final double THRESHOLD_RATE = 0.35;

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        if (!(e.getSource() instanceof JComboBox)) {
            return;
        }
        JComboBox comboBox = (JComboBox)e.getSource();
        if (!(comboBox.getAccessibleContext().getAccessibleChild(0) instanceof BasicComboPopup)) {
            return;
        }
        final BasicComboPopup popup = (BasicComboPopup)comboBox.getAccessibleContext().getAccessibleChild(0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComboBoxPopupListener.this.setPopupDirection(popup);
            }
        });
    }

    private void setPopupDirection(BasicComboPopup popup) {
        Component comboBox = popup.getInvoker();
        Point comboBoxLocationOnScreen = comboBox.getLocationOnScreen();
        Window window = SwingUtilities.getWindowAncestor(comboBox);
        int distanceBetweenComboBoxAndFrame = window.getLocationOnScreen().y + window.getHeight() - (comboBoxLocationOnScreen.y + comboBox.getPreferredSize().height);
        double rate = (double)distanceBetweenComboBoxAndFrame / (double)window.getHeight();
        if (Double.compare(rate, 0.35) == 1) {
            int height = comboBox.getPreferredSize().height;
            popup.setLocation(comboBoxLocationOnScreen.x, comboBoxLocationOnScreen.y + height - 5);
        } else {
            int height = popup.getPreferredSize().height;
            popup.setLocation(comboBoxLocationOnScreen.x, comboBoxLocationOnScreen.y - height);
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }
}

