/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.RenderingStrategy;
import com.ur.swing.g5.DefaultComboBoxRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class ComboBoxRenderer {
    private static final Color DEFAULT_BACKGROUND = UIManager.getColor("ComboBox.background");
    private static final Color DEFAULT_SELECTED_BACKGROUND = UIManager.getColor("ComboBox.selectionBackground");
    private static final Color UNDEFINED_WARNING_COLOR = UIManager.getColor("undefined.warning");
    private final Border originalBorder;
    private final Border errorBorder;
    private final RenderingStrategy renderingStrategy;

    private ComboBoxRenderer(JComboBox comboBox, RenderingStrategy renderingStrategy) {
        this.originalBorder = comboBox.getBorder();
        this.errorBorder = this.getErrorBorder(comboBox);
        this.renderingStrategy = renderingStrategy;
        comboBox.setRenderer(new ComboBoxCellRenderer());
        comboBox.addActionListener(new ItemStateListener());
        comboBox.addPropertyChangeListener("model", new ModelChangeListener());
    }

    private void updateSource(Object source) {
        if (source instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)source;
            Object selectedItem = comboBox.getSelectedItem();
            if (selectedItem != null && this.renderingStrategy.hasError(selectedItem)) {
                comboBox.setFont(comboBox.getFont().deriveFont(2));
                comboBox.setBorder(this.errorBorder);
            } else {
                comboBox.setFont(comboBox.getFont().deriveFont(0));
                comboBox.setBorder(this.originalBorder);
            }
        }
    }

    private Border getErrorBorder(JComboBox comboBox) {
        AbstractBorder spaceAroundOriginalBorder = new EmptyBorder(new Insets(1, 1, 1, 1));
        Border currentBorder = comboBox.getBorder();
        if (currentBorder != null) {
            spaceAroundOriginalBorder = new CompoundBorder(spaceAroundOriginalBorder, currentBorder);
        }
        return new CompoundBorder(new LineBorder(UNDEFINED_WARNING_COLOR, 2), spaceAroundOriginalBorder);
    }

    public static void bindRenderer(JComboBox comboBox, RenderingStrategy renderingStrategy) {
        com.ur.swing.g5.ComboBoxRenderer.unbindRenderer(comboBox);
        new ComboBoxRenderer(comboBox, renderingStrategy);
    }

    private class ComboBoxCellRenderer
    extends DefaultComboBoxRenderer {
        public ComboBoxCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 0));
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setOpaque(true);
            this.setText(ComboBoxRenderer.this.renderingStrategy.getText(value));
            this.setIcon(ComboBoxRenderer.this.renderingStrategy.getIcon(value));
            if (ComboBoxRenderer.this.renderingStrategy.hasError(value) && this.countItemsIn(list) > 0) {
                this.setFont(this.getFont().deriveFont(2));
                this.setBackground(UNDEFINED_WARNING_COLOR);
            } else if (isSelected) {
                this.setBackground(DEFAULT_SELECTED_BACKGROUND);
            } else {
                this.setFont(this.getFont().deriveFont(0));
                this.setBackground(DEFAULT_BACKGROUND);
            }
            return this;
        }

        private int countItemsIn(JList list) {
            return list.getModel().getSize();
        }
    }

    private class ItemStateListener
    implements ActionListener {
        private ItemStateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ComboBoxRenderer.this.updateSource(event.getSource());
        }
    }

    private class ModelChangeListener
    implements PropertyChangeListener {
        private ModelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            ComboBoxRenderer.this.updateSource(event.getSource());
        }
    }
}

