/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.ComboBox;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.LabelProvider;
import com.ur.swing.g5.DefaultComboBoxRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class ComboBoxWithErrorBorder<T>
extends ComboBox {
    private static final Color ERROR_COLOR = UIManager.getColor("ErrorColor");
    private Border originalBorder;
    private Border errorBorder = ComboBoxWithErrorBorder.createErrorBorder(this);
    private Color originalBackground;

    public ComboBoxWithErrorBorder(LabelProvider<T> provider, ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.originalBorder = this.getBorder();
        this.originalBackground = this.getBackground();
        this.setRenderer(new ComboBoxCellRenderer(provider));
        this.addActionListener(new ItemStateListener());
        this.addPropertyChangeListener("model", new ModelChangeListener());
    }

    private void updateDecoration() {
        this.removeErrorDecoration();
        if (this.hasError()) {
            this.addErrorDecoration();
        }
    }

    private void addErrorDecoration() {
        this.setFont(this.getFont().deriveFont(2));
        this.setBorder(this.errorBorder);
    }

    private void removeErrorDecoration() {
        this.setFont(this.getFont().deriveFont(0));
        this.setBorder(this.originalBorder);
        this.setBackground(this.originalBackground);
    }

    private static Border createErrorBorder(JComboBox comboBox) {
        AbstractBorder spaceAroundOriginalBorder = new EmptyBorder(new Insets(1, 1, 1, 1));
        Border originalBorder = comboBox.getBorder();
        if (originalBorder != null) {
            spaceAroundOriginalBorder = new CompoundBorder(spaceAroundOriginalBorder, originalBorder);
        }
        return new CompoundBorder(new LineBorder(ERROR_COLOR, 2), spaceAroundOriginalBorder);
    }

    @Override
    public void setError(String message) {
        super.setError(message);
        this.addErrorDecoration();
    }

    @Override
    public void clearError() {
        super.clearError();
        this.removeErrorDecoration();
    }

    private class ComboBoxCellRenderer
    extends DefaultComboBoxRenderer {
        private LabelProvider<T> provider;

        private ComboBoxCellRenderer(LabelProvider<T> provider) {
            this.provider = provider;
            this.setBackground(ComboBoxWithErrorBorder.this.originalBackground);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String text = this.provider.getText(value);
            this.setText(text);
            if (ComboBoxWithErrorBorder.this.hasError() && ComboBoxWithErrorBorder.this.getSelectedItem() == value) {
                this.setFont(this.getFont().deriveFont(2));
                this.setBackground(DisplayMessageFactory.ERROR_COLOR);
            } else {
                this.setFont(this.getFont().deriveFont(0));
                this.setBackground(ComboBoxWithErrorBorder.this.originalBackground);
            }
            return this;
        }
    }

    private class ItemStateListener
    implements ActionListener {
        private ItemStateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ComboBoxWithErrorBorder.this.updateDecoration();
        }
    }

    private class ModelChangeListener
    implements PropertyChangeListener {
        private ModelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            ComboBoxWithErrorBorder.this.updateDecoration();
        }
    }
}

