/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.lang.EqualsUtil;
import java.awt.Component;
import org.netbeans.jemmy.ComponentChooser;

public class ComponentDriver {
    public static ComponentChooser withName(final String withName) {
        return new ComponentChooser(){

            public String getDescription() {
                return "with name '" + withName + "'";
            }

            public boolean checkComponent(Component comp) {
                return EqualsUtil.equals((Object)comp.getName(), (Object)withName);
            }
        };
    }

    public static ComponentChooser showing() {
        return new ComponentChooser(){

            public String getDescription() {
                return "showing";
            }

            public boolean checkComponent(Component comp) {
                return comp.isShowing();
            }
        };
    }

    public static ComponentChooser enabled() {
        return new ComponentChooser(){

            public String getDescription() {
                return "enabled";
            }

            public boolean checkComponent(Component comp) {
                return comp.isEnabled();
            }
        };
    }

    public static ComponentChooser OfType(final Class clazz) {
        return new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return clazz.isInstance(component);
            }

            public String getDescription() {
                return "of type '" + clazz + "'";
            }
        };
    }

    public static ComponentChooser not(final ComponentChooser chooser) {
        return new ComponentChooser(){

            public String getDescription() {
                return "not " + chooser.getDescription();
            }

            public boolean checkComponent(Component comp) {
                return !chooser.checkComponent(comp);
            }
        };
    }

    public static ComponentChooser aComponent(String withName, ComponentChooser ... andChoosers) {
        ComponentChooser chooser = ComponentDriver.withName(withName);
        return new MultiComponentChooser(chooser, andChoosers);
    }

    public static class MultiComponentChooser
    implements ComponentChooser {
        private final ComponentChooser chooser;
        private final ComponentChooser[] andChoosers;

        public MultiComponentChooser(ComponentChooser chooser, ComponentChooser ... andChoosers) {
            this.chooser = chooser;
            this.andChoosers = andChoosers;
        }

        public String getDescription() {
            String result = "a component " + this.chooser.getDescription() + " ";
            int countDown = this.andChoosers.length;
            ComponentChooser[] componentChooserArray = this.andChoosers;
            int n = this.andChoosers.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentChooser each = componentChooserArray[n2];
                if (--countDown == 1) {
                    result = String.valueOf(result) + " and ";
                } else if (countDown != 0) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + each.getDescription();
                ++n2;
            }
            return result;
        }

        public boolean checkComponent(Component comp) {
            boolean result = this.chooser.checkComponent(comp);
            ComponentChooser[] componentChooserArray = this.andChoosers;
            int n = this.andChoosers.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentChooser each = componentChooserArray[n2];
                if (!each.checkComponent(comp)) {
                    result = false;
                    break;
                }
                ++n2;
            }
            return result;
        }
    }
}

