/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.lang.Defense;
import com.ur.lang.StringUtils;
import com.ur.swing.BindingRegistration;
import com.ur.swing.BindingRegistrationWasClosed;
import com.ur.swing.ComponentErrorable;
import com.ur.swing.DisplayMessageUtilities;
import com.ur.swing.ErrorBorder;
import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.URDialogType;
import com.ur.swing.number.NumberField;
import com.ur.swing.number.NumberPicker;
import com.ur.swing.text.TextPicker;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.EdgedBalloonStyle;
import net.java.balloontip.utils.TimingUtils;

public class DisplayMessageFactory {
    public static final Color ERROR_COLOR = ErrorBorder.ERROR_COLOR;
    public static final Color WARNING_COLOR = new Color(255, 255, 112);
    public static final Color INFORMATION_COLOR = new Color(194, 225, 246);
    public static final Color ATTENTION_COLOR = new Color(251, 238, 198);
    public static final Color OK_COLOR = Color.white;
    private static final int TIP_HORIZONTAL_OFFSET = 15;
    private static final int TIP_VERTICAL_OFFSET = 15;
    private static final MessageBalloonStyle ERROR_TOOL_TIP_STYLE = new MessageBalloonStyle(MessageBalloonStyle.ReportLevel.ERROR);
    private static final MessageBalloonStyle WARN_TOOL_TIP_STYLE = new MessageBalloonStyle(MessageBalloonStyle.ReportLevel.WARNING);
    private static final MessageBalloonStyle ATTENTION_TOOL_TIP_STYLE = new MessageBalloonStyle(MessageBalloonStyle.ReportLevel.ATTENTION);
    private static final MessageBalloonStyle INFORMATION_TOOL_TIP_STYLE = new MessageBalloonStyle(MessageBalloonStyle.ReportLevel.INFORMATION);
    private static final Map<JComponent, BindingRegistration> BALLOON_REGISTRATIONS = new ConcurrentHashMap<JComponent, BindingRegistration>();
    private static JFrame frame;
    private static boolean enabled;
    private static JComponent defaultComponent;
    private static long lastShownTooltipHashCode;

    static {
        enabled = true;
    }

    @Inject
    private DisplayMessageFactory() {
    }

    public static void setCurrentWindow(JFrame window) {
        frame = window;
    }

    public static BindingRegistrationWasClosed error(JComponent attachedComponent, String errorMessage) {
        if (!enabled) {
            return new DummyBindingRegistrationWasClosed();
        }
        if (!(attachedComponent instanceof ComponentErrorable)) {
            attachedComponent.setBackground(ERROR_COLOR);
        }
        if (!StringUtils.isNullOrOnlyWhitespace((String)errorMessage)) {
            if (lastShownTooltipHashCode != DisplayMessageFactory.tooltipHashCode(attachedComponent, errorMessage)) {
                BindingRegistrationWasClosed bindingRegistration = DisplayMessageFactory.displayTooltip(attachedComponent, errorMessage, (BalloonTipStyle)ERROR_TOOL_TIP_STYLE, BalloonTimeoutType.CLOSE_QUICKLY, BalloonClickType.IGNORE_CLICKS);
                lastShownTooltipHashCode = DisplayMessageFactory.tooltipHashCode(attachedComponent, errorMessage);
                return bindingRegistration;
            }
        } else if (DisplayMessageFactory.hasError(attachedComponent)) {
            DisplayMessageFactory.removeRegistration(attachedComponent);
        }
        return new DummyBindingRegistrationWasClosed();
    }

    private static long tooltipHashCode(JComponent attachedComponent, String errorMessage) {
        return (long)attachedComponent.hashCode() + 31L * (long)errorMessage.hashCode();
    }

    public static BindingRegistrationWasClosed warn(JComponent attachedComponent, String warningMessage) {
        if (!enabled || DisplayMessageFactory.hasError(attachedComponent)) {
            return new DummyBindingRegistrationWasClosed();
        }
        if (!DisplayMessageFactory.hasWarning(attachedComponent)) {
            attachedComponent.setBackground(WARNING_COLOR);
        }
        if (!StringUtils.isNullOrOnlyWhitespace((String)warningMessage)) {
            if (lastShownTooltipHashCode != DisplayMessageFactory.tooltipHashCode(attachedComponent, warningMessage)) {
                DisplayMessageFactory.clearPreviousWarnings();
                BindingRegistrationWasClosed bindingRegistration = DisplayMessageFactory.displayTooltip(attachedComponent, warningMessage, (BalloonTipStyle)WARN_TOOL_TIP_STYLE, BalloonTimeoutType.CLOSE_QUICKLY, BalloonClickType.IGNORE_CLICKS);
                lastShownTooltipHashCode = DisplayMessageFactory.tooltipHashCode(attachedComponent, warningMessage);
                return bindingRegistration;
            }
        } else {
            DisplayMessageFactory.removeRegistration(attachedComponent);
        }
        return new DummyBindingRegistrationWasClosed();
    }

    public static void closeAllPopups() {
        DisplayMessageFactory.clearPreviousWarnings();
    }

    private static void clearPreviousWarnings() {
        for (BindingRegistration registration : BALLOON_REGISTRATIONS.values()) {
            if (registration == null) continue;
            registration.removeRegistration();
        }
    }

    private static boolean hasWarning(JComponent attachedComponent) {
        return attachedComponent.getBackground().equals(WARNING_COLOR);
    }

    public static BindingRegistrationWasClosed messageWithTitle(JComponent attachedComponent, String title, String message) {
        return DisplayMessageFactory.messageWithTitle(attachedComponent, title, message, 0);
    }

    public static BindingRegistrationWasClosed messageWithTitle(JComponent attachedComponent, String title, String message, BalloonTip.AttachLocation attachLocation) {
        return DisplayMessageFactory.informCloseAnyClick(attachedComponent, DisplayMessageFactory.createMessage(title, message), attachLocation);
    }

    public static BindingRegistrationWasClosed messageWithTitleCloseOnlyOnClick(JComponent attachedComponent, String title, String message) {
        return DisplayMessageFactory.informationWithoutTimeout(attachedComponent, DisplayMessageFactory.createMessage(title, message));
    }

    public static BindingRegistrationWasClosed messageWithTitleCloseOnlyOnClick(JComponent attachedComponent, String title, String message, BalloonTip.AttachLocation attachLocation) {
        return DisplayMessageFactory.informationWithoutTimeout(attachedComponent, DisplayMessageFactory.createMessage(title, message), attachLocation);
    }

    public static BindingRegistrationWasClosed messageWithTitle(JComponent attachedComponent, String title, String message, int maxWidth) {
        if (maxWidth <= 0) {
            return DisplayMessageFactory.informCloseAnyClick(attachedComponent, DisplayMessageFactory.createMessage(title, message));
        }
        return DisplayMessageFactory.informCloseAnyClick(attachedComponent, DisplayMessageFactory.createMessage(title, message, maxWidth));
    }

    private static String createMessage(String title, String message) {
        return String.valueOf(HTML.fontBold((String)HTML.p((String)title))) + HTML.br() + HTML.p((String)message);
    }

    private static String createMessage(String title, String message, int maxWidth) {
        return String.valueOf(HTML.fontBold((String)HTML.p((String)title))) + HTML.br() + HTML.maxWidth((int)maxWidth, (String)message);
    }

    public static BindingRegistrationWasClosed inform(JComponent attachedComponent, String informationMessage) {
        return DisplayMessageFactory.inform(attachedComponent, informationMessage, false);
    }

    public static BindingRegistrationWasClosed informAndHighlight(JComponent attachedComponent, String informationMessage) {
        return DisplayMessageFactory.inform(attachedComponent, informationMessage, true);
    }

    private static BindingRegistrationWasClosed inform(JComponent attachedComponent, String informationMessage, boolean highlightComponent) {
        if (!enabled) {
            return new DummyBindingRegistrationWasClosed();
        }
        if (highlightComponent && !attachedComponent.getBackground().equals(INFORMATION_COLOR)) {
            attachedComponent.setBackground(INFORMATION_COLOR);
        }
        if (!StringUtils.isNullOrOnlyWhitespace((String)informationMessage)) {
            return DisplayMessageFactory.displayTooltip(attachedComponent, informationMessage, (BalloonTipStyle)INFORMATION_TOOL_TIP_STYLE, BalloonTimeoutType.CLOSE_QUICKLY, BalloonClickType.IGNORE_CLICKS);
        }
        return new DummyBindingRegistrationWasClosed();
    }

    public static BindingRegistrationWasClosed informCloseAnyClick(JComponent attachedComponent, String informationMessage) {
        return DisplayMessageFactory.informCloseAnyClick(attachedComponent, informationMessage, DisplayMessageFactory.getAttachLocation(attachedComponent, frame));
    }

    private static BindingRegistrationWasClosed informCloseAnyClick(JComponent attachedComponent, String informationMessage, BalloonTip.AttachLocation attachLocation) {
        if (!enabled) {
            return new DummyBindingRegistrationWasClosed();
        }
        return DisplayMessageFactory.displayTooltip(attachedComponent, informationMessage, (BalloonTipStyle)INFORMATION_TOOL_TIP_STYLE, BalloonTimeoutType.DELAY_ON_CLOSE, BalloonClickType.CLOSE_ON_CLICK, attachLocation);
    }

    public static BindingRegistrationWasClosed informCloseAnyClick(JComponent attachedComponent, String informationMessage, BalloonTip.AttachLocation attachLocation, Dimension resultingDimension, JComponent bottomLineAddon) {
        if (!enabled) {
            return new DummyBindingRegistrationWasClosed();
        }
        return DisplayMessageFactory.displayTooltip(attachedComponent, informationMessage, (BalloonTipStyle)INFORMATION_TOOL_TIP_STYLE, BalloonTimeoutType.DELAY_ON_CLOSE, BalloonClickType.CLOSE_ON_CLICK, attachLocation, resultingDimension, bottomLineAddon);
    }

    public static BindingRegistrationWasClosed attentionWithoutTimeout(JComponent attachedComponent, String informationMessage) {
        if (!enabled) {
            return new DummyBindingRegistrationWasClosed();
        }
        return DisplayMessageFactory.displayTooltip(attachedComponent, informationMessage, (BalloonTipStyle)ATTENTION_TOOL_TIP_STYLE, BalloonTimeoutType.NO_TIMEOUT_NO_BUTTON, BalloonClickType.CLOSE_ON_CLICK);
    }

    public static BindingRegistrationWasClosed attentionWithoutTimeout(JComponent attachedComponent, String informationMessage, BalloonTip.AttachLocation attachLocation, Dimension resultingDimension, JComponent bottomLineAddon) {
        if (!enabled) {
            return new DummyBindingRegistrationWasClosed();
        }
        return DisplayMessageFactory.displayTooltip(attachedComponent, informationMessage, (BalloonTipStyle)ATTENTION_TOOL_TIP_STYLE, BalloonTimeoutType.NO_TIMEOUT_NO_BUTTON, BalloonClickType.CLOSE_ON_CLICK, attachLocation, resultingDimension, bottomLineAddon);
    }

    private static BindingRegistrationWasClosed informationWithoutTimeout(JComponent attachedComponent, String informationMessage) {
        if (!enabled) {
            return new DummyBindingRegistrationWasClosed();
        }
        return DisplayMessageFactory.displayTooltip(attachedComponent, informationMessage, (BalloonTipStyle)INFORMATION_TOOL_TIP_STYLE, BalloonTimeoutType.CLOSE_NO_TIMEOUT, BalloonClickType.CLOSE_ON_CLICK);
    }

    public static BindingRegistrationWasClosed informationWithoutTimeout(JComponent attachedComponent, String informationMessage, BalloonTip.AttachLocation attachLocation, Dimension resultingDimension, JComponent bottomLineAddon) {
        if (!enabled) {
            return new DummyBindingRegistrationWasClosed();
        }
        return DisplayMessageFactory.displayTooltip(attachedComponent, informationMessage, (BalloonTipStyle)INFORMATION_TOOL_TIP_STYLE, BalloonTimeoutType.CLOSE_NO_TIMEOUT, BalloonClickType.CLOSE_ON_CLICK, attachLocation, resultingDimension, bottomLineAddon);
    }

    private static BindingRegistrationWasClosed informationWithoutTimeout(JComponent attachedComponent, String informationMessage, BalloonTip.AttachLocation attachLocation) {
        if (!enabled) {
            return new DummyBindingRegistrationWasClosed();
        }
        return DisplayMessageFactory.displayTooltip(attachedComponent, informationMessage, (BalloonTipStyle)INFORMATION_TOOL_TIP_STYLE, BalloonTimeoutType.CLOSE_NO_TIMEOUT, BalloonClickType.CLOSE_ON_CLICK, attachLocation);
    }

    private static BindingRegistrationWasClosed displayTooltip(JComponent attachedComponent, String informationMessage, BalloonTipStyle tipStyle, BalloonTimeoutType delayClose, BalloonClickType closeOnAnyClick) {
        BalloonTip.AttachLocation attachLocation = DisplayMessageFactory.getAttachLocation(attachedComponent, frame);
        return DisplayMessageFactory.displayTooltip(attachedComponent, informationMessage, tipStyle, delayClose, closeOnAnyClick, attachLocation);
    }

    private static BindingRegistrationWasClosed displayTooltip(JComponent attachedComponent, String informationMessage, BalloonTipStyle tipStyle, BalloonTimeoutType delayClose, BalloonClickType closeOnAnyClick, BalloonTip.AttachLocation attachLocation) {
        return DisplayMessageFactory.displayTooltip(attachedComponent, informationMessage, tipStyle, delayClose, closeOnAnyClick, attachLocation, new Dimension());
    }

    private static BindingRegistrationWasClosed displayTooltip(JComponent attachedComponent, String informationMessage, BalloonTipStyle tipStyle, BalloonTimeoutType delayClose, BalloonClickType closeOnAnyClick, BalloonTip.AttachLocation attachLocation, Dimension resultingDimension) {
        return DisplayMessageFactory.displayTooltip(attachedComponent, informationMessage, tipStyle, delayClose, closeOnAnyClick, attachLocation, resultingDimension, null);
    }

    private static BindingRegistrationWasClosed displayTooltip(JComponent attachedComponent, String informationMessage, BalloonTipStyle tipStyle, BalloonTimeoutType delayClose, BalloonClickType closeOnAnyClick, BalloonTip.AttachLocation attachLocation, Dimension resultingDimension, JComponent bottomLineAddon) {
        NumberField numberField;
        if (frame == null) {
            String additionalInfo = attachedComponent != null ? " (component: " + attachedComponent.getName() + ")" : "";
            Log.warning((String)("No parent window for message: " + informationMessage + additionalInfo));
            return BindingRegistrationWasClosed.NULL_REGISTRATION_WAS_CLOSED;
        }
        if (attachedComponent != null && SwingUtilities.getWindowAncestor(attachedComponent) instanceof JDialog) {
            return DisplayMessageFactory.getBindingRegistrationWasClosed(attachedComponent, informationMessage, tipStyle, delayClose, bottomLineAddon);
        }
        if (attachedComponent instanceof NumberField && !(numberField = (NumberField)attachedComponent).isAllowToolTip()) {
            return new DummyBindingRegistrationWasClosed();
        }
        JLabel contents = new JLabel();
        JPanel tooltip = new JPanel(new BorderLayout());
        tooltip.setOpaque(false);
        tooltip.add((Component)contents, "Center");
        if (bottomLineAddon != null) {
            tooltip.add((Component)bottomLineAddon, "South");
        }
        contents.setText(HTML.html((String)informationMessage));
        return DisplayMessageFactory.displayTooltip(attachedComponent, tooltip, tipStyle, delayClose, closeOnAnyClick, attachLocation, resultingDimension);
    }

    private static BindingRegistrationWasClosed getBindingRegistrationWasClosed(JComponent attachedComponent, String informationMessage, BalloonTipStyle tipStyle, BalloonTimeoutType delayClose, JComponent bottomLineAddon) {
        JLabel contents = new JLabel();
        if (bottomLineAddon != null) {
            Log.warning((String)"Addon component cannot be shown in tooltip over dialogs - not implemented");
        }
        if (attachedComponent.isShowing()) {
            contents.setText(HTML.html((String)HTML.lineBreakText((String)informationMessage, (int)20)));
            if (DisplayMessageFactory.isBalloonTipOnTopOfCanvas(attachedComponent, tipStyle, contents)) {
                return DisplayMessageFactory.displayTooltipForComponentInsideDialogOverCanvas3D(attachedComponent, tipStyle, delayClose, contents);
            }
            return DisplayMessageFactory.displayTooltipForComponentInsideDialog(attachedComponent, tipStyle, delayClose, contents);
        }
        return BindingRegistrationWasClosed.NULL_REGISTRATION_WAS_CLOSED;
    }

    private static boolean isBalloonTipOnTopOfCanvas(JComponent attachedComponent, BalloonTipStyle tipStyle, JLabel contents) {
        BalloonTip balloonTip = new BalloonTip((JComponent)frame.getRootPane(), (JComponent)contents, tipStyle, false);
        int width = balloonTip.getWidth();
        int height = balloonTip.getHeight();
        balloonTip.closeBalloon();
        Container contentPane = frame.getContentPane();
        Point p = SwingUtilities.convertPoint(attachedComponent, 0, 0, contentPane);
        p.x -= width;
        p.y += attachedComponent.getHeight();
        return SwingUtilities.getDeepestComponentAt(contentPane, p.x, p.y) instanceof Canvas || SwingUtilities.getDeepestComponentAt(contentPane, p.x + width, p.y) instanceof Canvas || SwingUtilities.getDeepestComponentAt(contentPane, p.x, p.y + height) instanceof Canvas || SwingUtilities.getDeepestComponentAt(contentPane, p.x + width, p.y + height) instanceof Canvas;
    }

    private static synchronized BindingRegistrationWasClosed displayTooltipForComponentInsideDialog(JComponent attachedComponent, BalloonTipStyle tipStyle, BalloonTimeoutType delayClose, JLabel contents) {
        Point p;
        BalloonTip balloonTip;
        DisplayMessageFactory.doRemoveRegistration(attachedComponent);
        Window dialog = SwingUtilities.getWindowAncestor(attachedComponent);
        if (dialog instanceof JDialog && ((JDialog)dialog).isModal()) {
            balloonTip = DisplayMessageFactory.setupBalloonTip(tipStyle, contents, attachedComponent, delayClose, true);
            p = DisplayMessageUtilities.getModalDialogPosition(attachedComponent, balloonTip, dialog);
        } else if (dialog.getName().equals(TextPicker.TEXT_PICKER)) {
            balloonTip = DisplayMessageFactory.setupBalloonTip(tipStyle, contents, attachedComponent, delayClose, false);
            p = DisplayMessageUtilities.getTextPickerPosition(attachedComponent, balloonTip, dialog, frame);
        } else if (dialog.getName().equals(URDialogType.NUMBER_PICKER.getDialogName())) {
            balloonTip = DisplayMessageFactory.setupBalloonTip(tipStyle, contents, attachedComponent, delayClose, true);
            p = DisplayMessageUtilities.getNumberPickerPosition(attachedComponent, balloonTip, frame);
        } else {
            balloonTip = DisplayMessageFactory.setupBalloonTip(tipStyle, contents, attachedComponent, delayClose, true);
            p = DisplayMessageUtilities.getGenericDialogPosition(attachedComponent, balloonTip, frame);
        }
        balloonTip.setLocation(p);
        CloseBalloonTipRequested newRegistration = new CloseBalloonTipRequested(balloonTip, delayClose, BalloonClickType.CLOSE_ON_CLICK);
        BALLOON_REGISTRATIONS.put(attachedComponent, newRegistration);
        return newRegistration;
    }

    private static BalloonTip setupBalloonTip(BalloonTipStyle tipStyle, JLabel contents, final JComponent attachedComponent, final BalloonTimeoutType delayClose, final boolean flipY) {
        final BalloonTip balloonTip = new BalloonTip((JComponent)frame.getRootPane(), (JComponent)contents, tipStyle, false);
        balloonTip.setPositioner(new BalloonTipPositioner(){

            public Point getTipLocation() {
                return null;
            }

            public void determineAndSetLocation(Rectangle rectangle) {
            }

            protected void onStyleChange() {
                BalloonTipStyle style = this.balloonTip.getStyle();
                style.flip(true, flipY);
                style.setHorizontalOffset(0);
            }
        });
        attachedComponent.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                attachedComponent.removeAncestorListener(this);
                new CloseBalloonTipRequested(balloonTip, delayClose, BalloonClickType.CLOSE_ON_CLICK).removeRegistration();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        return balloonTip;
    }

    private static synchronized BindingRegistrationWasClosed displayTooltipForComponentInsideDialogOverCanvas3D(final JComponent attachedComponent, BalloonTipStyle tipStyle, BalloonTimeoutType delayClose, JLabel contents) {
        DisplayMessageFactory.doRemoveRegistration(attachedComponent);
        final JDialog overlay = new JDialog(frame);
        overlay.setUndecorated(true);
        overlay.setResizable(false);
        overlay.getRootPane().setWindowDecorationStyle(0);
        overlay.setFocusableWindowState(false);
        JPanel panel = new JPanel();
        Container contentPane = overlay.getContentPane();
        contentPane.add(panel);
        panel.setLayout(new FlowLayout(2, 0, 0));
        JLabel label = new JLabel(" ");
        panel.add(label);
        boolean showClose = delayClose == BalloonTimeoutType.CLOSE_NO_TIMEOUT;
        BalloonTip balloonTip = new BalloonTip((JComponent)label, (JComponent)contents, tipStyle, BalloonTip.Orientation.RIGHT_BELOW, BalloonTip.AttachLocation.NORTHEAST, 0, 15, showClose);
        Dimension preferredSize = balloonTip.getPreferredSize();
        panel.setPreferredSize(preferredSize);
        overlay.pack();
        Point p = attachedComponent.getLocationOnScreen();
        p.x -= panel.getPreferredSize().width;
        p.y += attachedComponent.getHeight() + 1;
        overlay.setLocation(p);
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                overlay.setVisible(true);
                attachedComponent.grabFocus();
            }
        });
        final CloseBalloonTipRequested closeBalloonTipRequested = new CloseBalloonTipRequested(balloonTip, delayClose, overlay);
        attachedComponent.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                attachedComponent.removeAncestorListener(this);
                closeBalloonTipRequested.removeRegistration();
                overlay.dispose();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        BALLOON_REGISTRATIONS.put(attachedComponent, closeBalloonTipRequested);
        return closeBalloonTipRequested;
    }

    private static synchronized BindingRegistrationWasClosed displayTooltip(JComponent attachedComponent, JComponent toBeDisplayed, BalloonTipStyle tipStyle, BalloonTimeoutType delayClose, BalloonClickType closeOnAnyClick, BalloonTip.AttachLocation location, Dimension resultingDimension) {
        if (attachedComponent == null) {
            attachedComponent = defaultComponent;
        }
        if (attachedComponent.isShowing()) {
            DisplayMessageFactory.doRemoveRegistration(attachedComponent);
            BalloonTip.Orientation orientation = DisplayMessageFactory.getOrientation(attachedComponent, frame);
            boolean showClose = delayClose == BalloonTimeoutType.CLOSE_NO_TIMEOUT;
            BalloonTip newBalloonTip = new BalloonTip(attachedComponent, toBeDisplayed, tipStyle, orientation, location, 15, 15, showClose);
            resultingDimension.setSize(newBalloonTip.getSize());
            if (DisplayMessageFactory.closeOverlappingBalloonTips(newBalloonTip)) {
                newBalloonTip.refreshLocation();
            }
            CloseBalloonTipRequested newRegistration = new CloseBalloonTipRequested(newBalloonTip, delayClose, closeOnAnyClick);
            BALLOON_REGISTRATIONS.put(attachedComponent, newRegistration);
            return newRegistration;
        }
        return new DummyBindingRegistrationWasClosed();
    }

    private static BalloonTip.AttachLocation getAttachLocation(JComponent attachedComponent, JFrame window) {
        Point absolutePosition;
        if (attachedComponent != null && window != null && (DisplayMessageFactory.isCloseToTop(absolutePosition = SwingUtilities.convertPoint(attachedComponent.getParent(), attachedComponent.getLocation(), window)) || NumberPicker.isVisible() && NumberPicker.isAbove())) {
            return BalloonTip.AttachLocation.SOUTH;
        }
        return BalloonTip.AttachLocation.NORTH;
    }

    private static BalloonTip.Orientation getOrientation(JComponent attachedComponent, JFrame window) {
        Point absolutePosition = window != null ? SwingUtilities.convertPoint(attachedComponent.getParent(), attachedComponent.getLocation(), window) : new Point();
        if (DisplayMessageFactory.isCloseToTop(absolutePosition) || NumberPicker.isVisible() && NumberPicker.isAbove()) {
            return DisplayMessageFactory.isCloseToRight(absolutePosition, window) ? BalloonTip.Orientation.RIGHT_BELOW : BalloonTip.Orientation.LEFT_BELOW;
        }
        return DisplayMessageFactory.isCloseToRight(absolutePosition, window) ? BalloonTip.Orientation.RIGHT_ABOVE : BalloonTip.Orientation.LEFT_ABOVE;
    }

    public static void removeRegistration(JComponent attachedComponent) {
        lastShownTooltipHashCode = 0L;
        DisplayMessageFactory.doRemoveRegistration(attachedComponent);
    }

    private static void doRemoveRegistration(JComponent attachedComponent) {
        BindingRegistration registration = BALLOON_REGISTRATIONS.get(attachedComponent);
        if (registration != null) {
            registration.removeRegistration();
            Defense.isNull((Object)BALLOON_REGISTRATIONS.get(attachedComponent), (String)"Balloon registration still there after it has been removed!");
        }
    }

    private static boolean closeOverlappingBalloonTips(BalloonTip newBalloonTip) {
        boolean closedBalloonTip = false;
        for (BindingRegistration registration : BALLOON_REGISTRATIONS.values()) {
            Rectangle bounds;
            if (!(registration instanceof CloseBalloonTipRequested) || (bounds = ((CloseBalloonTipRequested)registration).getBalloonTipBounds()) == null || !bounds.intersects(newBalloonTip.getBounds())) continue;
            registration.removeRegistration();
            closedBalloonTip = true;
        }
        return closedBalloonTip;
    }

    private static boolean isCloseToTop(Point absolutePosition) {
        return absolutePosition.y <= 50;
    }

    private static boolean isCloseToRight(Point absolutePosition, JFrame window) {
        int magicConstantThatHasNiceUsability = 250;
        return window == null ? false : absolutePosition.x >= window.getWidth() - magicConstantThatHasNiceUsability;
    }

    public static void testingSetEnablement(boolean enabled) {
        DisplayMessageFactory.enabled = enabled;
    }

    public static boolean testingGetEnablement() {
        return enabled;
    }

    public static void registerDefaultComponent(JComponent rightSidePanel) {
        defaultComponent = rightSidePanel;
    }

    public static boolean hasError(Component field) {
        return ErrorBorder.hasError(field);
    }

    protected static enum BalloonClickType {
        CLOSE_ON_CLICK,
        IGNORE_CLICKS;

    }

    protected static enum BalloonTimeoutType {
        NO_TIMEOUT_NO_BUTTON,
        CLOSE_NO_TIMEOUT,
        DELAY_ON_CLOSE,
        CLOSE_QUICKLY;

    }

    private static class CloseBalloonTipRequested
    extends TimerTask
    implements MouseListener,
    BindingRegistrationWasClosed,
    PropertyChangeListener,
    ActionListener {
        private Component glassPane;
        private MouseListener glassPaneListener;
        private JDialog overlay;
        protected BalloonTip balloonTip;

        public CloseBalloonTipRequested(BalloonTip balloonTip, BalloonTimeoutType delayClose, JDialog overlay) {
            this(balloonTip, delayClose, BalloonClickType.CLOSE_ON_CLICK);
            this.overlay = overlay;
        }

        public CloseBalloonTipRequested(final BalloonTip balloonTip, BalloonTimeoutType delayClose, BalloonClickType closeOnAnyClick) {
            balloonTip.addMouseListener((MouseListener)this);
            balloonTip.getAttachedComponent().addPropertyChangeListener(this);
            switch (delayClose) {
                case NO_TIMEOUT_NO_BUTTON: 
                case CLOSE_NO_TIMEOUT: {
                    break;
                }
                case CLOSE_QUICKLY: {
                    TimingUtils.showTimedBalloon((BalloonTip)balloonTip, (int)4000, (ActionListener)this);
                    break;
                }
                default: {
                    TimingUtils.showTimedBalloon((BalloonTip)balloonTip, (int)10000, (ActionListener)this);
                }
            }
            this.balloonTip = balloonTip;
            if (closeOnAnyClick == BalloonClickType.CLOSE_ON_CLICK && frame != null) {
                this.glassPane = frame.getGlassPane();
                this.glassPaneListener = new MouseListener(){
                    private boolean pressed = false;

                    private void forwardEvent(MouseEvent e) {
                        if (!balloonTip.getBounds().contains(e.getPoint())) {
                            Container contentPane = frame.getContentPane();
                            Point containerPoint = SwingUtilities.convertPoint(glassPane, e.getPoint(), contentPane);
                            Component clickedComponent = SwingUtilities.getDeepestComponentAt(contentPane, containerPoint.x, containerPoint.y);
                            if (clickedComponent != null) {
                                MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(glassPane, e, clickedComponent);
                                clickedComponent.dispatchEvent(convertedEvent);
                            }
                        } else {
                            e.getID();
                            MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(glassPane, e, (Component)balloonTip);
                            Component targetComponent = balloonTip.findComponentAt(convertedEvent.getX(), convertedEvent.getY());
                            if (targetComponent != null) {
                                convertedEvent = SwingUtilities.convertMouseEvent(glassPane, e, targetComponent);
                                targetComponent.dispatchEvent(convertedEvent);
                                this.pressed = false;
                            }
                        }
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        this.forwardEvent(e);
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        try {
                            this.forwardEvent(e);
                        }
                        finally {
                            this.pressed = true;
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        try {
                            this.forwardEvent(e);
                            if (this.pressed) {
                                this.removeRegistration();
                            }
                        }
                        finally {
                            this.pressed = false;
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        this.forwardEvent(e);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        this.forwardEvent(e);
                    }
                };
                this.glassPane.addMouseListener(this.glassPaneListener);
                frame.setGlassPane(this.glassPane);
            }
        }

        @Override
        public void run() {
            this.closeBalloonTip();
        }

        @Override
        public void removeRegistration() {
            this.closeBalloonTip();
            BALLOON_REGISTRATIONS.values().remove(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.closeBalloonTip();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("visible")) {
                this.closeBalloonTip();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.closeBalloonTip();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeBalloonTip() {
            if (this.balloonTip != null) {
                CloseBalloonTipRequested closeBalloonTipRequested = this;
                synchronized (closeBalloonTipRequested) {
                    if (this.balloonTip == null) {
                        return;
                    }
                    lastShownTooltipHashCode = 0L;
                    this.balloonTip.removeMouseListener((MouseListener)this);
                    this.balloonTip.getAttachedComponent().removePropertyChangeListener(this);
                    this.balloonTip.closeBalloon();
                    this.balloonTip = null;
                    if (this.overlay != null) {
                        this.overlay.setSize(0, 0);
                    }
                    if (this.glassPaneListener != null && this.glassPane != null) {
                        this.glassPane.removeMouseListener(this.glassPaneListener);
                    }
                    this.glassPane = null;
                    this.glassPaneListener = null;
                    this.cancel();
                }
            }
        }

        private Rectangle getBalloonTipBounds() {
            BalloonTip tmpBalloonTip = this.balloonTip;
            if (tmpBalloonTip == null) {
                return null;
            }
            return tmpBalloonTip.getBounds();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public boolean wasClosed() {
            return this.balloonTip == null;
        }
    }

    private static final class DummyBindingRegistrationWasClosed
    implements BindingRegistrationWasClosed {
        private DummyBindingRegistrationWasClosed() {
        }

        @Override
        public boolean wasClosed() {
            return false;
        }

        @Override
        public void removeRegistration() {
        }
    }

    public static class MessageBalloonStyle
    extends EdgedBalloonStyle {
        private static final Color ERROR_FILL_COLOR = ERROR_COLOR;
        private static final Color ERROR_BORDER_COLOR = new Color(181, 13, 13);
        private static final Color WARNING_FILL_COLOR = WARNING_COLOR;
        private static final Color WARNING_BORDER_COLOR = new Color(204, 168, 99);
        private static final Color INFORMATION_FILL_COLOR = INFORMATION_COLOR;
        private static final Color INFORMATION_BORDER_COLOR = new Color(86, 160, 211);
        private static final Color ATTENTION_FILL_COLOR = ATTENTION_COLOR;
        private static final Color ATTENTION_BORDER_COLOR = new Color(240, 213, 152);
        private static final Insets ATTENTION_INSETS = new Insets(25, 15, 25, 15);
        private ReportLevel warningLevel;

        public MessageBalloonStyle(ReportLevel warningLevel) {
            super(warningLevel.getFillColor(), warningLevel.getBorderColor());
            this.warningLevel = warningLevel;
        }

        public ReportLevel getWarningLevel() {
            return this.warningLevel;
        }

        public Insets getBorderInsets(Component c) {
            Insets borderInsets = super.getBorderInsets(c);
            return new Insets(borderInsets.top + ((ReportLevel)this.warningLevel).insets.top, borderInsets.left + ((ReportLevel)this.warningLevel).insets.left, borderInsets.bottom + ((ReportLevel)this.warningLevel).insets.bottom, borderInsets.right + ((ReportLevel)this.warningLevel).insets.right);
        }

        static /* synthetic */ Color access$0() {
            return INFORMATION_FILL_COLOR;
        }

        static /* synthetic */ Color access$1() {
            return INFORMATION_BORDER_COLOR;
        }

        static /* synthetic */ Color access$2() {
            return ATTENTION_FILL_COLOR;
        }

        static /* synthetic */ Color access$3() {
            return ATTENTION_BORDER_COLOR;
        }

        static /* synthetic */ Insets access$4() {
            return ATTENTION_INSETS;
        }

        static /* synthetic */ Color access$5() {
            return WARNING_FILL_COLOR;
        }

        static /* synthetic */ Color access$6() {
            return WARNING_BORDER_COLOR;
        }

        static /* synthetic */ Color access$7() {
            return ERROR_FILL_COLOR;
        }

        static /* synthetic */ Color access$8() {
            return ERROR_BORDER_COLOR;
        }

        public static enum ReportLevel {
            INFORMATION(MessageBalloonStyle.access$0(), MessageBalloonStyle.access$1()),
            ATTENTION(MessageBalloonStyle.access$2(), MessageBalloonStyle.access$3(), MessageBalloonStyle.access$4()),
            WARNING(MessageBalloonStyle.access$5(), MessageBalloonStyle.access$6()),
            ERROR(MessageBalloonStyle.access$7(), MessageBalloonStyle.access$8());

            private final Color fillColor;
            private final Color borderColor;
            private final Insets insets;

            private ReportLevel(Color fillColor, Color borderColor) {
                this(fillColor, borderColor, new Insets(1, 1, 1, 1));
            }

            private ReportLevel(Color fillColor, Color borderColor, Insets insets) {
                this.fillColor = fillColor;
                this.borderColor = borderColor;
                this.insets = insets;
            }

            public Color getFillColor() {
                return this.fillColor;
            }

            public Color getBorderColor() {
                return this.borderColor;
            }

            public Insets getInsets() {
                return this.insets;
            }
        }
    }
}

