/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.java.balloontip.BalloonTip;

public class DisplayMessageUtilities {
    private DisplayMessageUtilities() {
    }

    public static Point getModalDialogPosition(JComponent attachedComponent, BalloonTip balloonTip, Window dialog) {
        Window frame = SwingUtilities.windowForComponent(attachedComponent);
        Point p = new Point();
        p.x = frame.getWidth() / 2 - dialog.getWidth() / 2;
        p.y = frame.getHeight() / 2 - dialog.getHeight() / 2;
        Point positionInDialog = SwingUtilities.convertPoint(attachedComponent, 0, 0, dialog);
        p.y += positionInDialog.y;
        p.x -= balloonTip.getWidth();
        p.y += attachedComponent.getHeight();
        return p;
    }

    public static Point getGenericDialogPosition(JComponent attachedComponent, BalloonTip balloonTip, JFrame frame) {
        Point p = SwingUtilities.convertPoint(attachedComponent, 0, 0, frame.getContentPane());
        p.y += attachedComponent.getHeight();
        if (DisplayMessageUtilities.canFitComponentLeft((Component)balloonTip, p.x)) {
            p.x -= balloonTip.getWidth();
        } else {
            p.x += attachedComponent.getWidth();
            balloonTip.getStyle().flipX(false);
        }
        return p;
    }

    private static boolean canFitComponentLeft(Component componentToPlace, int xPos) {
        return xPos - componentToPlace.getWidth() >= 0;
    }

    public static Point getNumberPickerPosition(JComponent attachedComponent, BalloonTip balloonTip, JFrame frame) {
        Point p = SwingUtilities.convertPoint(attachedComponent, 0, 0, frame.getContentPane());
        p.y += attachedComponent.getHeight();
        int borderTickness = UIManager.getInt("NumberPicker.borderThickness");
        if (DisplayMessageUtilities.canFitComponentLeft((Component)balloonTip, p.x - borderTickness)) {
            p.x -= balloonTip.getWidth() + borderTickness;
        } else {
            p.x += attachedComponent.getWidth() + borderTickness;
            balloonTip.getStyle().flipX(false);
        }
        return p;
    }

    public static Point getTextPickerPosition(JComponent attachedComponent, BalloonTip balloonTip, Window dialog, JFrame frame) {
        Point p = SwingUtilities.convertPoint(attachedComponent, 0, 0, frame.getContentPane());
        p.x = attachedComponent.getX();
        p.y -= balloonTip.getHeight() + SwingUtilities.convertPoint((Component)attachedComponent, (int)0, (int)0, (Component)dialog).y;
        return p;
    }
}

