/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import java.util.EnumMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;

public class EnumButtonGroup<T extends Enum<T>> {
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final EnumMap<T, AbstractButton> enumToRadioButton;

    public EnumButtonGroup(Class<T> type) {
        this.enumToRadioButton = new EnumMap(type);
    }

    public void add(T enumValue, AbstractButton button) {
        this.buttonGroup.add(button);
        this.enumToRadioButton.put(enumValue, button);
    }

    public void select(T key) {
        if (!this.hasReference(key)) {
            throw new MissingReferenceToRadioButton((Enum<?>)key);
        }
        this.get(key).setSelected(true);
    }

    public T selection(T defaultOrUndefined) {
        for (Map.Entry<T, AbstractButton> each : this.enumToRadioButton.entrySet()) {
            if (!each.getValue().isSelected()) continue;
            return (T)((Enum)each.getKey());
        }
        return defaultOrUndefined;
    }

    public boolean hasReference(T key) {
        return this.enumToRadioButton.containsKey(key);
    }

    public AbstractButton get(T key) {
        return this.enumToRadioButton.get(key);
    }

    public void clearSelection() {
        this.buttonGroup.clearSelection();
    }

    public static class MissingReferenceToRadioButton
    extends RuntimeException {
        public MissingReferenceToRadioButton(Enum<?> referencedBy) {
            super("Missing reference from '" + referencedBy.name() + "' to RadioButton");
        }
    }
}

