/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.LanguageConfiguration;
import com.ur.swing.URFontFactory;
import java.awt.Font;
import java.util.Locale;

public class FontFactory
extends URFontFactory.Template {
    public static final String DEFAULT_FONT = URFontFactory.Template.isMac ? "DejaVu Sans" : "DejaVu";
    private final int defaultSize;
    private final int largeSize;

    public FontFactory() {
        if (this.isRussian()) {
            this.defaultSize = 12;
            this.largeSize = 14;
        } else {
            this.defaultSize = 16;
            this.largeSize = 18;
        }
    }

    @Override
    public Font getRelativeFont(URFontFactory.Typeface typeface, URFontFactory.Style style, URFontFactory.Size size) {
        return new Font(this.getFontName(typeface), this.getFontStyle(style), this.getFontSize(size));
    }

    private String getFontName(URFontFactory.Typeface typeface) {
        String fontName;
        switch (typeface) {
            case MONOSPACED: {
                fontName = "Monospaced";
                break;
            }
            case SERIF: {
                fontName = "Serif";
                break;
            }
            default: {
                fontName = DEFAULT_FONT;
            }
        }
        return fontName;
    }

    private int getFontStyle(URFontFactory.Style style) {
        int fontStyle;
        switch (style) {
            case BOLD: {
                fontStyle = 1;
                break;
            }
            case ITALIC: {
                fontStyle = 2;
                break;
            }
            case BOLD_ITALIC: {
                fontStyle = 3;
                break;
            }
            default: {
                fontStyle = 0;
            }
        }
        return fontStyle;
    }

    private int getFontSize(URFontFactory.Size size) {
        int fontSize;
        switch (size) {
            case TINY: {
                fontSize = this.defaultSize - 6;
                if (!this.isRussian()) break;
                fontSize = this.defaultSize - 4;
                break;
            }
            case MAIN_HEADING_SIZE: {
                fontSize = this.defaultSize + 12;
                break;
            }
            case HUGE: {
                fontSize = this.defaultSize + 24;
                break;
            }
            default: {
                fontSize = this.getCommonFontSize(size);
            }
        }
        return fontSize;
    }

    private int getCommonFontSize(URFontFactory.Size size) {
        int fontSize;
        switch (size) {
            case VERY_SMALL: {
                fontSize = this.defaultSize - 4;
                break;
            }
            case SMALL: {
                fontSize = this.defaultSize - 2;
                break;
            }
            case MEDIUM: {
                fontSize = this.defaultSize + 1;
                break;
            }
            case LARGE: {
                fontSize = this.largeSize;
                break;
            }
            case VERY_LARGE: {
                fontSize = this.largeSize + 2;
                break;
            }
            default: {
                fontSize = this.defaultSize;
            }
        }
        return fontSize;
    }

    private boolean isRussian() {
        return Locale.getDefault().equals(LanguageConfiguration.SupportedLanguage.ru.getLocale());
    }
}

