/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.util.CollectionUtils;
import com.ur.util.logging.Log;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.tree.TreeNode;

public class GuiUtilities {
    public static final int SCROLLBAR_WIDTH = 28;

    private GuiUtilities() {
    }

    public static void setContainerEnabledRecursive(Container con, boolean val) {
        Component[] children = con.getComponents();
        int i = 0;
        while (i < children.length) {
            if (((Container)children[i]).getComponentCount() > 0) {
                GuiUtilities.setContainerEnabledRecursive((Container)children[i], val);
            }
            children[i].setEnabled(val);
            ++i;
        }
    }

    public static <T> List<T> getComponentsOfType(Class<T> type, Container c) {
        return CollectionUtils.filter(GuiUtilities.getAllComponents(c), type);
    }

    public static List<Component> getAllComponents(Container c) {
        Component[] comps = c.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        Component[] componentArray = comps;
        int n = comps.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            compList.add(comp);
            if (comp instanceof Container) {
                compList.addAll(GuiUtilities.getAllComponents((Container)comp));
            }
            ++n2;
        }
        return compList;
    }

    public static Collection<TreeNode> getDescendantsOfNode(TreeNode rootNode) {
        ArrayList<TreeNode> descendants = new ArrayList<TreeNode>();
        Enumeration<? extends TreeNode> children = rootNode.children();
        while (children.hasMoreElements()) {
            TreeNode o = children.nextElement();
            if (!(o instanceof TreeNode)) {
                Log.error((String)("The enumeration returned by children() contained a non-TreeNode: " + o));
                continue;
            }
            TreeNode node = o;
            if (node.isLeaf()) {
                descendants.add(node);
                continue;
            }
            descendants.addAll(GuiUtilities.getDescendantsOfNode(node));
        }
        return descendants;
    }

    public static void setFontForContainerRecursive(Container con, Font newFont) {
        Component[] children = con.getComponents();
        int i = 0;
        while (i < children.length) {
            if (((Container)children[i]).getComponentCount() > 0) {
                GuiUtilities.setFontForContainerRecursive((Container)children[i], newFont);
            }
            children[i].setFont(newFont);
            ++i;
        }
    }

    public static void setScrollbarWidthLarge(JScrollPane jspane) {
        Dimension newDims = new Dimension(28, Integer.MAX_VALUE);
        jspane.getVerticalScrollBar().setPreferredSize(newDims);
    }

    public static void setCursorBeforeLastQuoteInJTextField(JTextField field) {
        String text;
        if (field != null && (text = field.getText()).length() > 1 && text.substring(text.length() - 1).equals("\"")) {
            field.setCaretPosition(text.length() - 1);
        }
    }

    public static void setFingerDragScroll(JComponent tree) {
        new URFingerDragScrollMouseListener(tree);
    }
}

