/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.lang.PrimitiveUtils;

public enum HourFormat {
    H24,
    H12;

    private static final HourFormat DEFAULT_HOUR_FORMAT;

    static {
        DEFAULT_HOUR_FORMAT = H24;
    }

    public static HourFormat getHourFormat(String hourFormatStr) {
        return (HourFormat)PrimitiveUtils.parseEnum((String)hourFormatStr, HourFormat.class, (Enum)DEFAULT_HOUR_FORMAT);
    }

    public String getDisplayString() {
        switch (this) {
            case H24: {
                return "HH:mm:ss";
            }
            case H12: {
                return "h:mm:ss a";
            }
        }
        throw new IllegalArgumentException("Unknown hour format: " + this.name());
    }

    public String getSimpleDisplayString() {
        switch (this) {
            case H24: {
                return "HH";
            }
            case H12: {
                return "h";
            }
        }
        throw new IllegalArgumentException("Unknown hour format: " + this.name());
    }
}

