/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.border.AbstractBorder;

public class ImageBorder
extends AbstractBorder {
    private final BufferedImage left;
    private final BufferedImage bottom;
    private final BufferedImage corner;

    public ImageBorder(BufferedImage left, BufferedImage bottom, BufferedImage corner) {
        this.left = left;
        this.bottom = bottom;
        this.corner = corner;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.left != null) {
            g2d.setPaint(new TexturePaint(this.left, new Rectangle(this.left.getWidth(), this.left.getHeight())));
            g2d.fillRect(0, 0, this.left.getWidth(), height - (this.corner == null ? 0 : this.corner.getHeight()));
        }
        if (this.bottom != null) {
            g2d.setPaint(new TexturePaint(this.bottom, new Rectangle(this.bottom.getWidth(), this.bottom.getHeight())));
            g2d.fillRect(this.corner == null ? 0 : this.corner.getWidth(), height - this.bottom.getHeight(), width, this.bottom.getHeight());
        }
        if (this.corner != null) {
            g2d.drawImage((Image)this.corner, 0, height - this.corner.getHeight(), null);
        }
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.set(0, this.left == null ? 0 : this.left.getWidth(), this.bottom == null ? 0 : this.bottom.getHeight(), 0);
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

