/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CloseListener;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.PostProcess;
import com.ur.swing.StateBasedBorder;
import com.ur.swing.number.OnEditListener;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.text.TextPicker;
import com.ur.swing.validation.ValidationDocumentListener;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.ArrayUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class InputField
extends JTextField {
    private Border outerBorder;
    private final StateBasedBorder stateBorder;
    private ValidationStrategy errorValidationStrategy = ValidationStrategy.ALWAYS_VALID;
    private BindingRegistration bindingRegistration = BindingRegistration.NULL_REGISTRATION;
    private PostProcess process = PostProcess.NULL;
    private boolean allowsEmpty;

    public InputField() {
        ResetValueWhenInvalidFocusListener valueListener = new ResetValueWhenInvalidFocusListener();
        this.stateBorder = new StateBasedBorder(this);
        this.outerBorder = this.stateBorder;
        this.setBorder(this.outerBorder);
        this.setErrorValidationStrategy(null);
        this.addMouseListener(new InputFieldPicker());
        this.addFocusListener(valueListener);
        this.addActionListener(valueListener);
    }

    @Override
    public void setText(String t) {
        super.setText(this.process.transform(t));
        this.forceValidation();
        this.postActionEvent();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.resetBindingRegistration();
    }

    public void setSelected() {
        this.stateBorder.setSelected();
        this.repaint();
    }

    public void setUnselected() {
        this.stateBorder.setUnselected();
        this.repaint();
    }

    public void setAllowEmpty(boolean state) {
        this.allowsEmpty = state;
        this.resetBindingRegistration();
    }

    public boolean isAllowsEmpty() {
        return this.allowsEmpty;
    }

    public void setErrorValidationStrategy(ValidationStrategy ... validationStrategy) {
        this.errorValidationStrategy = ArrayUtils.isNullOrEmpty((Object[])validationStrategy) ? ValidationStrategy.ALWAYS_VALID : new ValidationStrategy.Composite(validationStrategy);
        this.resetBindingRegistration();
    }

    private void resetBindingRegistration() {
        this.bindingRegistration.removeRegistration();
        if (this.isEnabled()) {
            this.bindingRegistration = this.allowsEmpty ? this.bindValidators(new AllowEmptyOnErrorErrorStrategy(this.getErrorValidationStrategy()), ValidationFactory.getCannotBeEmptyValidatorNoErrorMessage()) : TextFieldUtils.bindValidator(this, this.getErrorValidationStrategy());
        }
        this.forceValidation();
    }

    private BindingRegistration bindValidators(AllowEmptyOnErrorErrorStrategy errorErrorStrategy, ValidationStrategy warningStrategy) {
        final ValidationDocumentListener documentValidation = new ValidationDocumentListener(this, errorErrorStrategy, warningStrategy, ValidationStrategy.ALWAYS_VALID);
        this.getDocument().addDocumentListener(documentValidation);
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                InputField.this.getDocument().removeDocumentListener(documentValidation);
            }
        };
    }

    public ValidationStrategy getErrorValidationStrategy() {
        return this.errorValidationStrategy;
    }

    public void setPostProcessor(PostProcess process) {
        this.process = process;
    }

    public boolean isSelected() {
        return this.stateBorder.isSelected();
    }

    @Override
    public void postActionEvent() {
        if (this.isValidValue()) {
            super.postActionEvent();
        }
    }

    public boolean isValidValue() {
        return this.getErrorValidationStrategy().isValid(this.getText());
    }

    public boolean hasError() {
        return this.getBackground() == DisplayMessageFactory.ERROR_COLOR;
    }

    public void addOnEditListener(OnEditListener editListener) {
        this.listenerList.add(OnEditListener.class, editListener);
    }

    public void forceValidation() {
        if (!this.isEnabled()) {
            this.setBackground(DisplayMessageFactory.OK_COLOR);
        } else if (this.allowsEmpty && StringUtils.isNullOrOnlyWhitespace((String)this.getText())) {
            this.setBackground(DisplayMessageFactory.WARNING_COLOR);
        } else if (!this.errorValidationStrategy.isValid(this.getText())) {
            this.setBackground(DisplayMessageFactory.ERROR_COLOR);
        } else {
            this.setBackground(DisplayMessageFactory.OK_COLOR);
        }
    }

    private static class AllowEmptyOnErrorErrorStrategy
    implements ValidationStrategy {
        private final ValidationStrategy validationStrategy;

        public AllowEmptyOnErrorErrorStrategy(ValidationStrategy validationStrategy) {
            this.validationStrategy = validationStrategy;
        }

        @Override
        public boolean isValid(String uncheckedString) {
            if (StringUtils.isNullOrOnlyWhitespace((String)uncheckedString)) {
                return true;
            }
            return this.validationStrategy.isValid(uncheckedString);
        }

        @Override
        public String getErrorMessage(String uncheckedString) {
            return this.validationStrategy.getErrorMessage(uncheckedString);
        }
    }

    private class InputFieldPicker
    extends MouseAdapter {
        private long timeToWaitAfterClose = System.currentTimeMillis();
        private TextPicker textPicker = null;

        private InputFieldPicker() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!InputField.this.isEnabled() || !InputField.this.isEditable()) {
                return;
            }
            if (this.textPicker == null && this.timeToWaitAfterClose < System.currentTimeMillis()) {
                JTextField textField = new JTextField(InputField.this.getText());
                textField.setName(TextPicker.TEXT_PICKER_TEXT_FIELD);
                final BindingRegistration registration = TextFieldUtils.bindValidator(textField, InputField.this.getErrorValidationStrategy());
                InputField.this.stateBorder.setSelected();
                InputField.this.setBackground(UIManager.getColor("textHighlight"));
                OnEditListener[] onEditListenerArray = (OnEditListener[])InputField.this.listenerList.getListeners(OnEditListener.class);
                int n = onEditListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OnEditListener each = onEditListenerArray[n2];
                    each.requestEdit();
                    ++n2;
                }
                textField.selectAll();
                this.textPicker = new TextPicker(new TextHolder(){

                    @Override
                    public String getText() {
                        return InputField.this.getText();
                    }

                    @Override
                    public void setText(String text) {
                        InputField.this.setText(text);
                        InputField.this.postActionEvent();
                    }
                });
                this.textPicker.setValidationStrategy(InputField.this.errorValidationStrategy);
                this.textPicker.addCloseListener(new CloseListener(){

                    @Override
                    public void onClose() {
                        InputFieldPicker.this.textPicker = null;
                        registration.removeRegistration();
                        InputFieldPicker.this.timeToWaitAfterClose = System.currentTimeMillis() + 300L;
                        InputField.this.stateBorder.setUnselected();
                        InputField.this.forceValidation();
                    }
                });
                int position = InputField.this.getLocationOnScreen().y + InputField.this.getHeight();
                this.textPicker.showInputPanelAt(InputField.this, position);
            }
        }
    }

    private class ResetValueWhenInvalidFocusListener
    implements FocusListener,
    ActionListener {
        private String originalValue;

        private ResetValueWhenInvalidFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.originalValue = InputField.this.getText();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.validateValueOnChange()) {
                InputField.super.postActionEvent();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.validateValueOnChange();
        }

        private boolean validateValueOnChange() {
            if (EqualsUtil.equals((Object)this.originalValue, (Object)InputField.this.getText())) {
                return false;
            }
            if (!InputField.this.isValidValue()) {
                InputField.this.setText(this.originalValue);
                return false;
            }
            return true;
        }
    }
}

