/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.GuiUtilities;
import com.ur.swing.ScreenUtils;
import com.ur.swing.SwingUtil;
import com.ur.util.Optional;
import com.ur.util.logging.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class JFrameUtils {
    public static final String TITLE_LABEL_NAME = "com.ur.view.label.Title";
    public static final String MAIN_FRAME_NAME = "urgui.URGUI";
    public static final String SPLASH_FRAME_NAME = "SPLASH_SCREEN_NAME";
    private static final List<String> APPLICATION_FRAME_NAMES = Arrays.asList("urgui.URGUI", "SPLASH_SCREEN_NAME");
    private static final int DEFAULT_APPLICATION_HEIGHT = 600;
    private static final Border DIALOG_TITLE_BORDER = UIManager.getBorder("URDialog.titleBorder");
    private static final Border DIALOG_BORDER = UIManager.getBorder("URDialog.border");

    private JFrameUtils() {
    }

    public static void moveToCenter(JDialog dialog, int offsetY, boolean calledFromSplashScreenCode) {
        try {
            Dimension dim = dialog.getContentPane().getSize();
            Rectangle screenBounds = ScreenUtils.getScreenBounds();
            int x = (screenBounds.width - dim.width) / 2 + screenBounds.x;
            int y = (screenBounds.height - dim.height) / 2 + offsetY + screenBounds.y;
            if (calledFromSplashScreenCode) {
                dialog.setLocation((800 - dim.width) / 2, 5);
            } else {
                dialog.setLocation(x, y);
            }
        }
        catch (Exception e) {
            Log.error((String)"ScreenUtils failed", (Throwable)e);
        }
    }

    public static JPanel createDialogContent(String title, JComponent panel) {
        JPanel result = new JPanel();
        JPanel titlePanel = new JPanel();
        JPanel messagePanel = new JPanel();
        JScrollPane innerScrollPane = new JScrollPane(messagePanel);
        GuiUtilities.setFingerDragScroll(messagePanel);
        result.setBorder(DIALOG_BORDER);
        result.setLayout(new BorderLayout());
        result.add((Component)titlePanel, "North");
        innerScrollPane.setBorder(BorderFactory.createEmptyBorder());
        result.add((Component)innerScrollPane, "Center");
        titlePanel.setLayout(new FlowLayout(1));
        titlePanel.setBackground(new Color(67, 136, 201));
        titlePanel.setBorder(DIALOG_TITLE_BORDER);
        if (title != null) {
            JLabel titleLabel = new JLabel(String.valueOf(title) + " ");
            titleLabel.setName(TITLE_LABEL_NAME);
            titleLabel.setFont(new Font("Dialog", 1, 13));
            titleLabel.setForeground(new Color(255, 255, 255));
            titlePanel.add(titleLabel);
        }
        messagePanel.add(panel);
        return result;
    }

    public static boolean contains(Component component, JPanel panel) {
        List<Component> allComponents = SwingUtil.getAllComponents((Container)component, JPanel.class);
        return allComponents.contains(panel);
    }

    private static Optional<JFrame> getActiveFrame() {
        Frame[] frameArray = Frame.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame each = frameArray[n2];
            if (each.isVisible() && each instanceof JFrame) {
                return Optional.of((Object)((JFrame)each));
            }
            ++n2;
        }
        return Optional.empty();
    }

    public static Optional<JFrame> getApplicationFrame() {
        Frame[] frameArray = Frame.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame each = frameArray[n2];
            if (each instanceof JFrame && each.isVisible() && APPLICATION_FRAME_NAMES.contains(each.getName())) {
                return Optional.of((Object)((JFrame)each));
            }
            ++n2;
        }
        return Optional.empty();
    }

    public static Optional<JFrame> getApplicationMainFrame() {
        Frame[] frameArray = Frame.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame each = frameArray[n2];
            if (each instanceof JFrame && each.isVisible() && MAIN_FRAME_NAME.equals(each.getName())) {
                return Optional.of((Object)((JFrame)each));
            }
            ++n2;
        }
        return Optional.empty();
    }

    private static Optional<JFrame> getAnyFrame() {
        Frame[] frameArray = Frame.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame each = frameArray[n2];
            if (each instanceof JFrame) {
                return Optional.of((Object)((JFrame)each));
            }
            ++n2;
        }
        return Optional.empty();
    }

    public static JFrame getActiveOrNullFrame() {
        Optional<JFrame> frame = JFrameUtils.getActiveFrame();
        return frame.isPresent() ? (JFrame)frame.get() : null;
    }

    public static Optional<JFrame> getParentFrame() {
        Optional<JFrame> frame = JFrameUtils.getApplicationFrame();
        if (!frame.isPresent() && !(frame = JFrameUtils.getActiveFrame()).isPresent()) {
            frame = JFrameUtils.getAnyFrame();
        }
        return frame;
    }

    public static void adjustHeightToFitInApplication(Component component, int margin) {
        int applicationHeight = JFrameUtils.getApplicationHeight();
        if (JFrameUtils.isTooHigh(component, applicationHeight)) {
            JFrameUtils.setSizeWithScrollbar(component, applicationHeight - margin);
        }
    }

    private static void setSizeWithScrollbar(Component component, int height) {
        int width = component.getPreferredSize().width + 28;
        component.setPreferredSize(new Dimension(width, height));
    }

    private static boolean isTooHigh(Component component, int parentHeight) {
        return component.getPreferredSize().getHeight() > (double)parentHeight;
    }

    private static int getApplicationHeight() {
        return JFrameUtils.getApplicationFrame().isPresent() ? Math.max(((JFrame)JFrameUtils.getApplicationFrame().get()).getHeight(), 600) : 600;
    }
}

