/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.util.logging.Log;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class JTreeUtils {
    public static void selectNodeFromInsertEvent(JTree features, TreeModelEvent e) {
        try {
            Object[] path = e.getChildren();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path[0];
            JTreeUtils.selectNodeFromTree(features, node);
        }
        catch (Exception ex) {
            Log.error((String)"Should never be given a node that's not in the tree", (Throwable)ex);
            features.setSelectionRow(0);
        }
    }

    private static void selectNodeFromTree(JTree tree, DefaultMutableTreeNode node) {
        Object[] nodePath = ((DefaultTreeModel)tree.getModel()).getPathToRoot(node);
        TreePath treePath = new TreePath(nodePath);
        tree.setSelectionPath(treePath);
    }

    public static void selectPreviousNodeFromRemoveEvent(JTree tree, TreeModelEvent e) {
        try {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)((DefaultTreeModel)e.getSource()).getRoot();
            DefaultMutableTreeNode obj = (DefaultMutableTreeNode)root.getChildAt(e.getChildIndices()[0] - 1);
            JTreeUtils.selectNodeFromTree(tree, obj);
        }
        catch (Exception ex) {
            Log.error((String)"This should never happen", (Throwable)ex);
            tree.setSelectionRow(0);
        }
    }
}

