/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.lang.EqualsUtil;
import com.ur.swing.SwingThreadFlushes;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JFileChooserOperator;
import org.netbeans.jemmy.operators.JFrameOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JPasswordFieldOperator;
import org.netbeans.jemmy.operators.JRadioButtonOperator;
import org.netbeans.jemmy.operators.JSliderOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.JTextAreaOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JToggleButtonOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.WindowOperator;
import org.netbeans.jemmy.util.NameComponentChooser;
import org.netbeans.jemmy.util.PNGEncoder;

public class JemmyUtils {
    public static final String VERBOSE_LOGGING = "verbose.logging";
    public static final String TRACE_LOGGING = "trace.logging";
    public static final int NUMBER_OF_TIMES_TO_FLUSH = 10;
    public static final String TAKE_SCREEN_SHOTS_PROPERTY_NAME = "TakeScreenShots";
    public static final String PROBLEM_WITH_DIMENSIONS = "Problem with %d and %d dimensions were %d and %d and %d and %d";
    private static final TestableEventQueue TESTABLE_EVENT_QUEUE = new TestableEventQueue();

    static {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        eventQueue.push(TESTABLE_EVENT_QUEUE);
        JemmyProperties.setCurrentProperty((String)VERBOSE_LOGGING, (Object)true);
        JemmyProperties.setCurrentProperty((String)TRACE_LOGGING, (Object)false);
        JemmyProperties.setCurrentOutput((TestOut)new QuieterTestOut());
    }

    private JemmyUtils() {
    }

    public static boolean isIdle() {
        return TESTABLE_EVENT_QUEUE.peekEvent() == null;
    }

    public static JListOperator getListByName(Object frameOrFrameOperator, String name) {
        return new JListOperator(JemmyUtils.getContainer(frameOrFrameOperator), (ComponentChooser)new NameComponentChooser(name));
    }

    public static void selectElementInListByName(JFrame frame, String name, Object toClick) {
        JListOperator listByName = JemmyUtils.getListByName(frame, name);
        ListModel model = listByName.getModel();
        int i = 0;
        while (i < model.getSize()) {
            Object elementAt = model.getElementAt(i);
            if (EqualsUtil.equals(elementAt, (Object)toClick)) {
                listByName.selectItem(i);
                return;
            }
            ++i;
        }
        throw new IllegalStateException("Failed to select item '" + toClick + "' in JList with name '" + name + "'");
    }

    public static JRadioButtonOperator getRadioButtonByName(Object frameOrFrameOperator, String name) {
        return new JRadioButtonOperator(JemmyUtils.getContainer(frameOrFrameOperator), (ComponentChooser)new NameComponentChooser(name));
    }

    public static JButtonOperator getButtonByName(Object frameOrFrameOperator, String name) {
        return new JButtonOperator(JemmyUtils.getContainer(frameOrFrameOperator), (ComponentChooser)new NameComponentChooser(name));
    }

    public static JCheckBoxOperator getCheckBoxByName(Object frameOrFrameOperator, String name) {
        return new JCheckBoxOperator(JemmyUtils.getContainer(frameOrFrameOperator), (ComponentChooser)new NameComponentChooser(name));
    }

    public static JToggleButtonOperator getToggleButtonByName(Object frameOrFrameOperator, String name) {
        return new JToggleButtonOperator(JemmyUtils.getContainer(frameOrFrameOperator), (ComponentChooser)new NameComponentChooser(name));
    }

    public static JTextFieldOperator getTextFieldByName(Object frameOrFrameOperator, String name) {
        return new JTextFieldOperator(JemmyUtils.getContainer(frameOrFrameOperator), (ComponentChooser)new NameComponentChooser(name));
    }

    public static JPasswordFieldOperator getPasswordFieldByName(Object frameOrFrameOperator, String name) {
        return new JPasswordFieldOperator(JemmyUtils.getContainer(frameOrFrameOperator), (ComponentChooser)new NameComponentChooser(name));
    }

    public static JComboBoxOperator getComboBoxByName(Object frameOrFrameOperator, String name) {
        return new JComboBoxOperator(JemmyUtils.getContainer(frameOrFrameOperator), (ComponentChooser)new NameComponentChooser(name));
    }

    public static JTextAreaOperator getTextAreaByName(Object frameOrFrameOperator, String name) {
        return new JTextAreaOperator(JemmyUtils.getContainer(frameOrFrameOperator), (ComponentChooser)new NameComponentChooser(name));
    }

    public static JLabelOperator getLabelByName(Object frameOrFrameOperator, String name) {
        return new JLabelOperator(JemmyUtils.getContainer(frameOrFrameOperator), (ComponentChooser)new NameComponentChooser(name));
    }

    public static JSliderOperator getSliderByName(Object frameOrFrameOperator, String name) {
        return new JSliderOperator(JemmyUtils.getContainer(frameOrFrameOperator), (ComponentChooser)new NameComponentChooser(name));
    }

    public static JTabbedPaneOperator getTabbedPaneByName(Object frameOrFrameOperator, String name) {
        return new JTabbedPaneOperator(JemmyUtils.getContainer(frameOrFrameOperator), (ComponentChooser)new NameComponentChooser(name));
    }

    public static JTreeOperator getTreeByName(Object frameOrFrameOperator, String name) {
        return new JTreeOperator(JemmyUtils.getContainer(frameOrFrameOperator), (ComponentChooser)new NameComponentChooser(name));
    }

    public static JDialogOperator getDialogWithName(String name) {
        return new JDialogOperator((ComponentChooser)new NameComponentChooser(name));
    }

    public static JDialogOperator getDialogWithName(Object frame, String name) {
        return new JDialogOperator((WindowOperator)JemmyUtils.getContainer(frame), (ComponentChooser)new NameComponentChooser(name));
    }

    public static JComponentOperator getComponentByName(Object frame, String name) {
        return new JComponentOperator(JemmyUtils.getContainer(frame), (ComponentChooser)new NameComponentChooser(name));
    }

    public static void pushCheckboxWithName(Object frame, String name) {
        JCheckBoxOperator checkboxByName = JemmyUtils.getCheckBoxByName(frame, name);
        if (!checkboxByName.isEnabled()) {
            throw new IllegalStateException("[" + name + "] is not enabled to press checkbox");
        }
        checkboxByName.clickMouse();
    }

    public static void pushButtonWithName(Object frameOrFrameOperator, String name) {
        JButtonOperator buttonByName = JemmyUtils.getButtonByName(frameOrFrameOperator, name);
        if (!buttonByName.isEnabled()) {
            throw new IllegalStateException("[" + name + "] is not enabled to press button");
        }
        try {
            buttonByName.push();
        }
        catch (Exception e) {
            Log.error((String)("Could not push button with name '" + name + "', trying to click it instead"), (Throwable)e);
            buttonByName.doClick();
        }
    }

    public static void pushLabelWithName(JFrame frame, String name) {
        JLabelOperator labelByName = JemmyUtils.getLabelByName(frame, name);
        if (!labelByName.isEnabled()) {
            throw new IllegalStateException("[" + name + "] is not enabled to press label");
        }
        labelByName.clickMouse();
    }

    public static JFileChooserOperator getFileChooser() {
        return new JFileChooserOperator();
    }

    public static void pushToggleButtonWithName(Object frameOrFrameOperator, String name) {
        JToggleButtonOperator toggleButtonByName = JemmyUtils.getToggleButtonByName(frameOrFrameOperator, name);
        toggleButtonByName.push();
    }

    public static ContainerOperator<?> getContainer(Object frameOrFrameOperator) {
        JFrameOperator frameOperator = null;
        if (frameOrFrameOperator instanceof JFrame) {
            frameOperator = new JFrameOperator((JFrame)frameOrFrameOperator);
        } else if (frameOrFrameOperator instanceof JPanel) {
            frameOperator = new ContainerOperator((Container)((JPanel)frameOrFrameOperator));
        } else if (frameOrFrameOperator instanceof ContainerOperator) {
            frameOperator = (ContainerOperator)frameOrFrameOperator;
        } else if (frameOrFrameOperator instanceof JDialog) {
            frameOperator = new JDialogOperator((JDialog)frameOrFrameOperator);
        }
        return frameOperator;
    }

    public static void typeKey(JFrame frame, String field, int key) throws InterruptedException {
        JTextFieldOperator operator = JemmyUtils.getTextFieldByName(frame, field);
        operator.pressKey(key);
        Thread.sleep(500L);
        operator.releaseKey(key);
    }

    @Deprecated
    public static void waitForIdle(int timeout, TimeUnit unit) {
        JemmyUtils.waitUntilIdle(timeout, unit);
    }

    public static boolean waitUntilIdle(int timeout, TimeUnit unit) {
        return Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return JemmyUtils.isIdle();
            }
        }, (int)timeout, (TimeUnit)unit);
    }

    public static JFrameOperator wrap(JFrame supportLogReader) {
        return new JFrameOperator(supportLogReader);
    }

    public static void takePhoto(Component component, String fileName) {
        try {
            Waiting.until((Waiting.ItHappens)new SwingThreadFlushes(10), (int)5, (TimeUnit)TimeUnit.SECONDS);
            boolean success = JemmyUtils.captureScreen(component, String.valueOf(fileName) + ".png", (byte)2);
            int tries = 0;
            while (!success) {
                if (++tries == 10) {
                    throw new RuntimeException("Failed to take photo with filename " + fileName);
                }
                Waiting.pause((long)2L, (TimeUnit)TimeUnit.SECONDS);
                success = JemmyUtils.captureScreen(component, String.valueOf(fileName) + ".png", (byte)2);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to take photo with filename " + fileName, e);
        }
    }

    private static boolean captureScreen(Component component, String fileName, byte mode) {
        BufferedImage ioe;
        block3: {
            Rectangle rectangle = new Rectangle(component.getLocationOnScreen(), component.getSize());
            try {
                ioe = new Robot().createScreenCapture(rectangle);
                if (!JemmyUtils.hasLargeBlackArea(ioe)) break block3;
                return false;
            }
            catch (Exception e) {
                Log.error((String)"Failed to capture screen", (Throwable)e);
                return false;
            }
        }
        BufferedOutputStream file = new BufferedOutputStream(new FileOutputStream(fileName));
        PNGEncoder encoder = new PNGEncoder((OutputStream)file, mode);
        encoder.encode(ioe);
        return true;
    }

    public static boolean hasLargeBlackArea(BufferedImage bufferedImage) {
        int discoveredLines = 0;
        int xMin = bufferedImage.getMinX();
        int xMax = bufferedImage.getMinX() + bufferedImage.getWidth() - 6;
        int yMin = bufferedImage.getMinY();
        int yMax = bufferedImage.getMinY() + bufferedImage.getHeight() - 6;
        int y = yMin;
        while (y < yMax) {
            int blackPixelsOnLine = 0;
            int x = xMin;
            while (x < xMax) {
                if ((blackPixelsOnLine = JemmyUtils.getBlackPixelsOnLine(bufferedImage, x, y, blackPixelsOnLine)) >= 20) {
                    ++discoveredLines;
                    break;
                }
                x += 5;
            }
            if (discoveredLines >= 3) {
                JemmyUtils.tryReportBlackLinesIssue(bufferedImage);
                return true;
            }
            y += 5;
        }
        return false;
    }

    private static void tryReportBlackLinesIssue(BufferedImage bufferedImage) {
        Log.error((String)"Large black area, rejecting");
        try {
            BufferedOutputStream file = new BufferedOutputStream(new FileOutputStream("ERROR_All_black_image.png"));
            PNGEncoder encoder = new PNGEncoder((OutputStream)file, 2);
            encoder.encode(bufferedImage);
        }
        catch (Exception e) {
            Log.error((String)"Failed to create failed image", (Throwable)e);
        }
    }

    private static int getBlackPixelsOnLine(BufferedImage bufferedImage, int x, int y, int blackPixelsOnLine) {
        try {
            int sample = bufferedImage.getRGB(x, y);
            blackPixelsOnLine = sample == Color.BLACK.getRGB() ? ++blackPixelsOnLine : 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Log.error((String)String.format(PROBLEM_WITH_DIMENSIONS, x, y, bufferedImage.getMinX(), bufferedImage.getMinY(), bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        return blackPixelsOnLine;
    }

    public static void initialize() {
    }

    public static boolean doTakeScreenShots() {
        Object takeScreenShotObject = JemmyProperties.getCurrentProperty((String)TAKE_SCREEN_SHOTS_PROPERTY_NAME);
        if (takeScreenShotObject == null) {
            return false;
        }
        return Boolean.parseBoolean(takeScreenShotObject.toString());
    }

    public static void setTakeScreenShots(boolean takeScreenShots) {
        JemmyProperties.setCurrentProperty((String)TAKE_SCREEN_SHOTS_PROPERTY_NAME, (Object)Boolean.toString(takeScreenShots));
    }

    public static JDialogOperator getDialogByTitle(final String title) {
        return new JDialogOperator(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                System.out.println("JemmyUtils.checkComponent");
                try {
                    JDialogOperator dialogOperator = new JDialogOperator((JDialog)component);
                    System.out.println("Dialog properties: Name = " + dialogOperator.getName() + ", Title = " + dialogOperator.getTitle() + ", isVisible = " + dialogOperator.isVisible());
                    return dialogOperator.isVisible() && title != null && title.equals(dialogOperator.getTitle());
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public String getDescription() {
                return " with title '" + title + "'";
            }
        });
    }

    private static final class QuieterTestOut
    extends TestOut {
        public static final String MILLISECONDS = "milliseconds";
        private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss:SSS");

        private QuieterTestOut() {
        }

        public void printLine(String text) {
            if (((Boolean)JemmyProperties.getCurrentProperty((String)JemmyUtils.VERBOSE_LOGGING)).booleanValue()) {
                try {
                    this.beautifyLogging(text);
                }
                catch (Exception exception) {
                    super.printLine("*** Failed to beautify output: ***");
                    super.printLine(text);
                }
            }
        }

        public void printErrLine(String line) {
            if (((Boolean)JemmyProperties.getCurrentProperty((String)JemmyUtils.VERBOSE_LOGGING)).booleanValue()) {
                super.printErrLine(this.appendTimestamp(line));
            }
        }

        public void printStackTrace(Throwable e) {
            this.printErrLine(this.appendTimestamp(e.getMessage()));
            super.printStackTrace(e);
        }

        public void printTrace(String text) {
            if (((Boolean)JemmyProperties.getCurrentProperty((String)JemmyUtils.TRACE_LOGGING)).booleanValue()) {
                super.printTrace(this.appendTimestamp(text));
            }
        }

        private void printLineWithTimestamp(String line) {
            super.printLine(this.appendTimestamp(line));
        }

        private void beautifyLogging(String text) {
            if (this.isIgnored(text)) {
                return;
            }
            if (text.startsWith("Scroll")) {
                String startOfMessage = text.substring(0, text.indexOf(":"));
                text = startOfMessage.replace("JList", "component named '" + this.findWidgetName(text) + "'");
            } else if (text.contains(MILLISECONDS)) {
                text = this.removeAllAfterMilliSeconds(text);
                text = this.removeAllQuotations(text);
            } else if (text.contains("Push button")) {
                text = " Push button with name '" + this.findWidgetName(text) + "'";
            } else if (text.contains("Wait AbstractButton")) {
                text = this.removeAllAfterMilliSeconds(text);
                text = this.removeAllQuotations(text);
            } else {
                text = this.removeAllQuotations(text);
            }
            this.printLineWithTimestamp(text);
        }

        private String removeAllQuotations(String text) {
            return text.replace("\"", "");
        }

        private String findWidgetName(String text) {
            return text.substring(text.indexOf(91) + 1, text.indexOf(44));
        }

        private String removeAllAfterMilliSeconds(String text) {
            return text.substring(0, text.indexOf(MILLISECONDS) + MILLISECONDS.length());
        }

        private boolean isIgnored(String text) {
            return text.startsWith("\"") || text.startsWith("Trace:") || text.startsWith("Start to wait") || text.startsWith("Activate window");
        }

        private String appendTimestamp(String logLine) {
            return String.valueOf(this.simpleDateFormat.format(new Date())) + " " + logLine;
        }
    }

    private static class TestableEventQueue
    extends EventQueue {
        private TestableEventQueue() {
        }

        @Override
        public void postEvent(AWTEvent theEvent) {
            super.postEvent(theEvent);
        }
    }
}

