/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.swing.HourFormat;
import com.ur.util.logging.Log;
import java.util.Locale;
import org.apache.commons.lang3.text.WordUtils;

public class LanguageConfiguration {
    SupportedLanguage language = SupportedLanguage.en;
    private Region region = Region.GLOBAL;
    boolean useEnglishProgramming;

    public LanguageConfiguration() {
        this(SupportedLanguage.DEFAULT_LANGUAGE, Region.GLOBAL, true);
    }

    public LanguageConfiguration(SupportedLanguage language, Region region, boolean useEnglishProgramming) {
        this.setLanguage(language);
        this.region = region;
        this.useEnglishProgramming = useEnglishProgramming;
    }

    public SupportedLanguage getLanguage() {
        return this.language;
    }

    public boolean isUsingEnglishProgramming() {
        return this.useEnglishProgramming;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setUseEnglishProgramming(boolean useEnglishProgramming) {
        this.useEnglishProgramming = useEnglishProgramming;
    }

    public void setLanguage(SupportedLanguage language) {
        this.language = language;
        Locale.setDefault(language.getLocale());
    }

    public void setLanguage(String languageName) {
        this.setLanguage(SupportedLanguage.getLanguage(languageName));
    }

    public String toString() {
        return "LanguageConfig: {\n\t" + (Object)((Object)this.getLanguage()) + ", \n\t" + (Object)((Object)this.getRegion()) + ", \n\tUsing EP: " + this.isUsingEnglishProgramming() + "\n}";
    }

    public static enum Region {
        GLOBAL,
        US;


        public static Region getRegion(String name) {
            return (Region)PrimitiveUtils.parseEnum((String)name, Region.class, (Enum)GLOBAL);
        }

        public HourFormat getDefaultHourFormat() {
            if (this == US) {
                return HourFormat.H12;
            }
            return HourFormat.H24;
        }

        public String getName() {
            if (this == US) {
                return "US";
            }
            return WordUtils.capitalizeFully((String)this.name());
        }
    }

    public static enum SupportedLanguage {
        en("Int'l English"),
        us("English (US)", "en", "US"),
        de("Deutsch"),
        es("Espa\u00f1ol"),
        fr("Fran\u00e7ais"),
        it("Italiano"),
        nl("Nederlands"),
        da("Dansk"),
        no("Norsk"),
        sv("Svenska"),
        zh("\u4e2d\u6587\u7248 (\u7b80\u4f53) ", "CN"),
        tr("T\u00fcrk"),
        pl("Polski"),
        cs("\u010ce\u0161tina"),
        sl("Sloven\u0161\u010dina"),
        sk("Sloven\u010dina"),
        jp("\u65e5\u672c\u8a9e"),
        ru("\u0420\u0443\u0441\u0441\u043a\u0438\u0439"),
        pt("Portugu\u00eas", "BR"),
        ko("\ud55c\uad6d\uc5b4"),
        hu("Magyar"),
        ro("Rom\u00e2n\u0103"),
        zt("\u7e41\u9ad4\u5b57", Locale.TRADITIONAL_CHINESE);

        private static final SupportedLanguage DEFAULT_LANGUAGE;
        private final String title;
        private final Locale locale;

        static {
            DEFAULT_LANGUAGE = en;
        }

        private SupportedLanguage(String title) {
            this.title = title;
            this.locale = new Locale(this.name());
        }

        private SupportedLanguage(String title, Locale locale) {
            this.title = title;
            this.locale = locale;
        }

        private SupportedLanguage(String title, String country) {
            this.title = title;
            this.locale = new Locale(this.name(), country);
        }

        private SupportedLanguage(String title, String local, String country) {
            this.title = title;
            this.locale = new Locale(local, country);
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getLanguageName() {
            return "_" + this.name();
        }

        public String getHelpLanguageName() {
            if (this.equals((Object)us)) {
                return en.getLanguageName();
            }
            return this.getLanguageName();
        }

        public String getHelpRegionName() {
            if (this.equals((Object)us)) {
                return "_" + Region.US.getName();
            }
            return "_" + Region.GLOBAL.getName();
        }

        public String toString() {
            return this.title;
        }

        public static SupportedLanguage getLanguage(String languageName) {
            if (StringUtils.isNullOrOnlyWhitespace((String)languageName)) {
                return DEFAULT_LANGUAGE;
            }
            SupportedLanguage[] supportedLanguageArray = SupportedLanguage.values();
            int n = supportedLanguageArray.length;
            int n2 = 0;
            while (n2 < n) {
                SupportedLanguage each = supportedLanguageArray[n2];
                if (languageName.contains(each.name())) {
                    return each;
                }
                ++n2;
            }
            Log.error((String)("Unsupported language type: " + languageName));
            return DEFAULT_LANGUAGE;
        }

        public static SupportedLanguage unmarshal(String persistedLanguage) {
            return SupportedLanguage.valueOf(persistedLanguage);
        }
    }
}

