/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;

public abstract class LongPressListener
extends MouseAdapter {
    private Timer t;
    private boolean isLongPress = false;
    private int longPressLimitInMS = 500;

    public LongPressListener() {
    }

    public LongPressListener(int longPressLimitInMS) {
        this.longPressLimitInMS = longPressLimitInMS;
    }

    public abstract void onShortPress();

    public abstract void onLongPress();

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.t == null) {
            this.isLongPress = false;
            this.t = new Timer();
            this.t.schedule(new TimerTask(){

                @Override
                public void run() {
                    LongPressListener.this.isLongPress = true;
                    LongPressListener.this.onLongPress();
                }
            }, this.longPressLimitInMS);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.t != null) {
            this.mouseReleased(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.t != null) {
            this.t.cancel();
            this.t = null;
        }
        if (!this.isLongPress) {
            this.onShortPress();
        }
    }
}

