/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;

public abstract class MouseAndFocusAdapter {
    private final MouseAndFocusListener mouseOrFocusListener = new MouseAndFocusListener();

    public abstract void onMousePressed(MouseEvent var1);

    public abstract void onMouseReleasedOrFocusLost(MouseEvent var1);

    public void addListenerTo(JComponent component) {
        component.addMouseListener(this.mouseOrFocusListener);
        component.addFocusListener(this.mouseOrFocusListener);
    }

    public void removeListenerFrom(JComponent component) {
        component.removeMouseListener(this.mouseOrFocusListener);
        component.removeFocusListener(this.mouseOrFocusListener);
    }

    private class MouseAndFocusListener
    extends MouseAdapter
    implements FocusListener {
        private final AtomicBoolean isPressed = new AtomicBoolean(false);

        private MouseAndFocusListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.isPressed.compareAndSet(false, true)) {
                this.ensureLostFocusEventsWillBeTriggered(e);
                MouseAndFocusAdapter.this.onMousePressed(e);
            }
        }

        private void ensureLostFocusEventsWillBeTriggered(MouseEvent e) {
            if (e.getComponent() != null) {
                e.getComponent().requestFocus();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isPressed.compareAndSet(true, false)) {
                MouseAndFocusAdapter.this.onMouseReleasedOrFocusLost(e);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.mouseReleased(this.createMouseEvent(e.getComponent()));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseReleased(this.createMouseEvent(e.getComponent()));
        }

        private MouseEvent createMouseEvent(Component component) {
            return new MouseEvent(component, 502, System.currentTimeMillis(), 0, 0, 0, 1, false);
        }
    }
}

