/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.AuthorizationException;
import com.ur.swing.BundleClassAuthorizer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import javax.swing.plaf.PanelUI;

public class RestrictedPanel
extends JPanel {
    private static final int CALLER_CLASS_DEPTH = 4;
    private static final int MAX_CLASS_DEPTH = 8;
    private final Dimension size;
    private final BundleClassAuthorizer classAuthorizer;

    public RestrictedPanel(Dimension size, Border border, BundleClassAuthorizer classAuthorizer) {
        super.setBorder(border);
        this.size = size;
        this.classAuthorizer = classAuthorizer;
    }

    @Override
    public Container getParent() {
        this.checkAuthorization();
        return super.getParent();
    }

    @Override
    public JRootPane getRootPane() {
        this.checkAuthorization();
        return super.getRootPane();
    }

    @Override
    public void setUI(PanelUI panelUI) {
        this.checkAuthorization();
        super.setUI(panelUI);
    }

    @Override
    public void setBackground(Color bg) {
        this.checkAuthorization();
        super.setBackground(bg);
    }

    @Override
    public void setLocation(int x, int y) {
        this.checkAuthorization();
        super.setLocation(x, y);
    }

    @Override
    public void setLocation(Point p) {
        this.checkAuthorization();
        super.setLocation(p);
    }

    @Override
    public void setBorder(Border border) {
        this.checkAuthorization();
        super.setBorder(border);
    }

    @Override
    public void setForeground(Color fg) {
        this.checkAuthorization();
        super.setForeground(fg);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.checkAuthorization();
        super.paintComponent(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        this.checkAuthorization();
        super.paintChildren(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        this.checkAuthorization();
        super.paintBorder(g);
    }

    @Override
    public void update(Graphics g) {
        this.checkAuthorization();
        super.update(g);
    }

    @Override
    public void paintAll(Graphics g) {
        this.checkAuthorization();
        super.paintAll(g);
    }

    @Override
    public void paintComponents(Graphics g) {
        this.checkAuthorization();
        super.paintComponents(g);
    }

    @Override
    public void paint(Graphics g) {
        this.checkAuthorization();
        super.paint(g);
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.checkAuthorization();
        super.setPreferredSize(preferredSize);
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        this.checkAuthorization();
        super.setOpaque(isOpaque);
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.checkAuthorization();
        super.setCursor(cursor);
    }

    @Override
    public void setSize(int width, int height) {
        this.checkAuthorization();
        super.setSize(width, height);
    }

    @Override
    @Deprecated
    public void resize(int width, int height) {
        this.checkAuthorization();
        super.resize(width, height);
    }

    @Override
    public void setSize(Dimension d) {
        this.checkAuthorization();
        super.setSize(d);
    }

    @Override
    @Deprecated
    public void resize(Dimension d) {
        this.checkAuthorization();
        super.resize(d);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.checkAuthorization();
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setBounds(Rectangle r) {
        this.checkAuthorization();
        super.setBounds(r);
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.size);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.size);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.size);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.size);
    }

    @Override
    public int getWidth() {
        return new Dimension((Dimension)this.size).width;
    }

    @Override
    public int getHeight() {
        return new Dimension((Dimension)this.size).height;
    }

    private void checkAuthorization() {
        if (!this.isCallingClassAuthorized()) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            AuthorizationException authorizationException = new AuthorizationException("Method not supported from URCaps");
            authorizationException.setStackTrace(stackTrace);
            throw authorizationException;
        }
    }

    private boolean isCallingClassAuthorized() {
        if (this.classAuthorizer == null) {
            return true;
        }
        boolean isAuthorized = true;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int stackTraceSize = Math.min(stackTrace.length, 8);
        int pos = 4;
        while (pos < stackTraceSize) {
            String className = stackTrace[pos].getClassName();
            if (!className.equals(this.getClass().getName()) && !(isAuthorized = this.classAuthorizer.isAuthorized(className))) {
                if (pos == 4) break;
                String subClassName = stackTrace[pos - 1].getClassName();
                if (subClassName.equals(this.getClass().getName())) {
                    isAuthorized = true;
                    break;
                }
                isAuthorized = this.classAuthorizer.isAuthorized(subClassName);
                break;
            }
            ++pos;
        }
        return isAuthorized;
    }
}

