/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class RotatedIcon
implements Icon {
    private Icon icon;
    private Rotate rotate;
    private double angle;

    public RotatedIcon(Icon icon) {
        this(icon, Rotate.UP);
    }

    public RotatedIcon(Icon icon, Rotate rotate) {
        this.icon = icon;
        this.rotate = rotate;
    }

    public RotatedIcon(Icon icon, double angle) {
        this(icon, Rotate.ABOUT_CENTER);
        this.angle = angle;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Rotate getRotate() {
        return this.rotate;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public int getIconWidth() {
        if (this.rotate == Rotate.UPSIDE_DOWN || this.rotate == Rotate.ABOUT_CENTER) {
            return this.icon.getIconWidth();
        }
        return this.icon.getIconHeight();
    }

    @Override
    public int getIconHeight() {
        if (this.rotate == Rotate.UPSIDE_DOWN || this.rotate == Rotate.ABOUT_CENTER) {
            return this.icon.getIconHeight();
        }
        return this.icon.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        BufferedImage bufferedImage = new BufferedImage(this.icon.getIconWidth(), this.icon.getIconHeight(), 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        this.icon.paintIcon(c, graphics, 0, 0);
        if (this.rotate == Rotate.DOWN) {
            g2.translate(x + this.getIconWidth(), y);
            g2.rotate(Math.toRadians(90.0));
        } else if (this.rotate == Rotate.UP) {
            g2.translate(x, y + this.getIconHeight());
            g2.rotate(Math.toRadians(-90.0));
        } else if (this.rotate == Rotate.UPSIDE_DOWN) {
            g2.translate(x + this.getIconWidth(), y + this.getIconHeight());
            g2.rotate(Math.toRadians(180.0));
        } else if (this.rotate == Rotate.ABOUT_CENTER) {
            double cWidth = (double)this.icon.getIconWidth() / 2.0;
            double cHeight = (double)this.icon.getIconHeight() / 2.0;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.translate(x, y);
            g2.rotate(Math.toRadians(this.getAngle()), cWidth, cHeight);
        }
        g2.drawImage(bufferedImage, null, 0, 0);
    }

    public static enum Rotate {
        DOWN,
        UP,
        UPSIDE_DOWN,
        ABOUT_CENTER;

    }
}

