/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.JFrameUtils;
import com.ur.swing.Skin;
import com.ur.util.Optional;
import com.ur.util.logging.Log;
import java.awt.Container;
import java.awt.Rectangle;
import javax.inject.Inject;
import javax.swing.JFrame;

public class ScreenUtils {
    private static Skin skin;
    private static int urguiScreenYposition;
    private static boolean urGuiToBeCenteredOnScreen;
    private static boolean isUrGuiCenteredOnScreen;
    private static boolean disableUrGuiRepositioning;

    static {
        urguiScreenYposition = 0;
        urGuiToBeCenteredOnScreen = true;
        isUrGuiCenteredOnScreen = true;
        disableUrGuiRepositioning = false;
    }

    private ScreenUtils() {
    }

    @Inject
    public static void setSkin(Skin skin) {
        ScreenUtils.skin = skin;
    }

    public static boolean urGuiToBeCenterOnScreen() {
        return urGuiToBeCenteredOnScreen;
    }

    public static void centerURGUIOnScreen() {
        if (ScreenUtils.isDisableUrGuiRepositioning()) {
            return;
        }
        Container parentFrame = (Container)JFrameUtils.getParentFrame().get();
        if (!urGuiToBeCenteredOnScreen) {
            parentFrame.setLocation(parentFrame.getX(), urguiScreenYposition);
            urGuiToBeCenteredOnScreen = true;
        }
    }

    static void slideURGUIVerticallyFromScreen(int verticalSlide) {
        if (ScreenUtils.isDisableUrGuiRepositioning()) {
            return;
        }
        Container parentFrame = (Container)JFrameUtils.getParentFrame().get();
        if (!urGuiToBeCenteredOnScreen) {
            ScreenUtils.centerURGUIOnScreen();
        }
        urguiScreenYposition = parentFrame.getBounds().y;
        parentFrame.setLocation(parentFrame.getBounds().x, parentFrame.getBounds().y + verticalSlide);
        urGuiToBeCenteredOnScreen = false;
    }

    public static Rectangle getScreenBounds() {
        Rectangle screenBounds = new Rectangle(800, 600);
        if (skin == null) {
            Log.error((String)"Skin not specified");
        } else {
            screenBounds = new Rectangle(skin.getResolution());
        }
        Optional<JFrame> applicationFrame = JFrameUtils.getApplicationFrame();
        if (applicationFrame.isPresent()) {
            screenBounds = ((JFrame)applicationFrame.get()).getBounds();
        }
        if (!urGuiToBeCenteredOnScreen) {
            screenBounds.y = urguiScreenYposition;
        }
        return screenBounds;
    }

    public static void setUrGuiCenteredOnScreen(boolean isUrGuiCenteredOnScreen) {
        ScreenUtils.isUrGuiCenteredOnScreen = isUrGuiCenteredOnScreen;
    }

    public static boolean isUrGuiCenteredOnScreen() {
        return isUrGuiCenteredOnScreen;
    }

    public static boolean isDisableUrGuiRepositioning() {
        return disableUrGuiRepositioning;
    }

    public static void setDisableUrGuiRepositioning(boolean disableUrGuiRepositioning) {
        ScreenUtils.disableUrGuiRepositioning = disableUrGuiRepositioning;
    }
}

