/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.util.logging.Log;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShiftKeyDelegate
implements ActionListener {
    private final ShiftKeyContext shiftKeyContext = new ShiftKeyContext(new OFF());
    private JButton button;
    private static int DEFAULT_INITIAL_LONG_PRESS_ACTION_DELAY = 500;
    private Timer timer;

    public ShiftKeyDelegate(JButton button) {
        this.button = button;
        this.createTimer(DEFAULT_INITIAL_LONG_PRESS_ACTION_DELAY);
        this.setButtonListener(button);
    }

    private void createTimer(int initialDelay) {
        this.timer = new Timer(initialDelay, this);
        this.timer.setRepeats(false);
    }

    private void setButtonListener(JButton button) {
        button.addChangeListener(new ButtonModelListener(button));
    }

    public void setShiftStateListener(ShiftStateListener shiftStateListener) {
        this.shiftKeyContext.setShiftStateListener(shiftStateListener);
    }

    public void otherKeyClicked() {
        this.shiftKeyContext.otherKeyPressed();
    }

    public boolean isShift() {
        State state = this.shiftKeyContext.getState();
        return state instanceof Locked || state instanceof ON;
    }

    private void buttonPressed() {
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
        this.shiftKeyContext.press();
    }

    private void buttonReleased() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.shiftKeyContext.shortReleased();
    }

    private void buttonTimeout() {
        this.shiftKeyContext.longReleased();
        this.button.getModel().setPressed(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.buttonTimeout();
    }

    private class AbstractState
    implements State {
        private AbstractState() {
        }

        @Override
        public void press(ShiftKeyContext shiftKeyContext) {
            Log.warning((String)("ERROR Illegal state operation STATE: " + shiftKeyContext.getState().getClass().getName() + "OPERATION: press"));
        }

        @Override
        public void longRelease(ShiftKeyContext shiftKeyContext) {
            Log.warning((String)("ERROR Illegal state operation STATE: " + shiftKeyContext.getState().getClass().getName() + "OPERATION: longRelease"));
        }

        @Override
        public void shortRelease(ShiftKeyContext shiftKeyContext) {
            Log.warning((String)("ERROR Illegal state operation STATE: " + shiftKeyContext.getState().getClass().getName() + "OPERATION: shortRelease"));
        }

        @Override
        public void otherKeyPressed(ShiftKeyContext shiftKeyContext) {
            Log.warning((String)("ERROR Illegal state operation STATE: " + shiftKeyContext.getState().getClass().getName() + "OPERATION: otherKeyPressed"));
        }
    }

    private class ButtonModelListener
    implements ChangeListener {
        private final JButton button;
        private boolean isPressed = false;

        public ButtonModelListener(JButton button) {
            this.button = button;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.button.getModel().isPressed() != this.isPressed) {
                this.isPressed = this.button.getModel().isPressed();
                this.buttonPressChanged();
            }
        }

        private void buttonPressChanged() {
            if (this.isPressed) {
                ShiftKeyDelegate.this.buttonPressed();
            } else {
                ShiftKeyDelegate.this.buttonReleased();
            }
        }
    }

    private class Locked
    extends AbstractState {
        private Locked() {
        }

        @Override
        public void press(ShiftKeyContext shiftKeyContext) {
            shiftKeyContext.setState(new PressedFromOn());
        }

        @Override
        public void otherKeyPressed(ShiftKeyContext shiftKeyContext) {
        }

        @Override
        public void shortRelease(ShiftKeyContext shiftKeyContext) {
        }
    }

    private class OFF
    extends AbstractState {
        private OFF() {
        }

        @Override
        public void press(ShiftKeyContext shiftKeyContext) {
            shiftKeyContext.setState(new PressedFromOff());
        }

        @Override
        public void otherKeyPressed(ShiftKeyContext shiftKeyContext) {
        }

        @Override
        public void shortRelease(ShiftKeyContext shiftKeyContext) {
        }
    }

    private class ON
    extends AbstractState {
        private ON() {
        }

        @Override
        public void press(ShiftKeyContext shiftKeyContext) {
            shiftKeyContext.setState(new PressedFromOn());
        }

        @Override
        public void otherKeyPressed(ShiftKeyContext shiftKeyContext) {
            shiftKeyContext.setState(new OFF());
        }
    }

    private class PressedFromOff
    extends AbstractState {
        private PressedFromOff() {
        }

        @Override
        public void longRelease(ShiftKeyContext shiftKeyContext) {
            shiftKeyContext.setState(new Locked());
        }

        @Override
        public void shortRelease(ShiftKeyContext shiftKeyContext) {
            shiftKeyContext.setState(new ON());
        }
    }

    private class PressedFromOn
    extends AbstractState {
        private PressedFromOn() {
        }

        @Override
        public void longRelease(ShiftKeyContext shiftKeyContext) {
            shiftKeyContext.setState(new OFF());
        }

        @Override
        public void shortRelease(ShiftKeyContext shiftKeyContext) {
            shiftKeyContext.setState(new OFF());
        }
    }

    private class ShiftKeyContext {
        private State state;
        private ShiftStateListener shiftStateListener;

        private ShiftKeyContext(State state) {
            this.state = state;
        }

        private void setShiftStateListener(ShiftStateListener shiftStateListener) {
            this.shiftStateListener = shiftStateListener;
        }

        void press() {
            this.state.press(this);
        }

        void longReleased() {
            this.state.longRelease(this);
        }

        void shortReleased() {
            this.state.shortRelease(this);
        }

        void otherKeyPressed() {
            this.state.otherKeyPressed(this);
        }

        private void setState(State state) {
            boolean stateChanged = this.state != state;
            this.state = state;
            if (stateChanged) {
                this.notifyListener();
            }
        }

        private void notifyListener() {
            if (this.shiftStateListener != null) {
                if (this.state instanceof OFF) {
                    this.shiftStateListener.shiftOff();
                } else if (this.state instanceof Locked) {
                    this.shiftStateListener.shiftLock();
                } else if (this.state instanceof ON) {
                    this.shiftStateListener.shiftOnce();
                }
            }
        }

        State getState() {
            return this.state;
        }
    }

    public static interface ShiftStateListener {
        public void shiftOnce();

        public void shiftOff();

        public void shiftLock();
    }

    private static interface State {
        public void press(ShiftKeyContext var1);

        public void longRelease(ShiftKeyContext var1);

        public void shortRelease(ShiftKeyContext var1);

        public void otherKeyPressed(ShiftKeyContext var1);
    }
}

