/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.lang.Defense;
import com.ur.swing.ArgumentProvider;
import com.ur.swing.CardChangedListener;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.ShowScreenAction;
import com.ur.swing.SwitchSupport;
import java.awt.event.ActionEvent;

public class ShowScreenActionImpl
extends ShowScreenAction {
    private final Class<? extends CardPanel> legacyPanelClass;
    private final boolean stackCurrentCard;
    private final ArgumentProvider argumentProvider;
    private FlipManager flipManager;
    private boolean enablementRequested = true;

    public ShowScreenActionImpl(Class<? extends CardPanel> legacyPanelClass, FlipManager flipManager) {
        this(legacyPanelClass, flipManager, false);
    }

    public ShowScreenActionImpl(Class<? extends CardPanel> legacyPanelClass, FlipManager flipManager, boolean stackCurrentCard) {
        this(legacyPanelClass, flipManager, stackCurrentCard, ArgumentProvider.NULL_PROVIDER);
    }

    public ShowScreenActionImpl(Class<? extends CardPanel> legacyPanelClass, FlipManager flipManager, boolean stackCurrentCard, ArgumentProvider argumentProvider) {
        Defense.notNull(legacyPanelClass, (String)"Destination panel type cannot be null.");
        Defense.notNull((Object)argumentProvider, (String)"Argument provider cannot be null.");
        this.legacyPanelClass = legacyPanelClass;
        this.stackCurrentCard = stackCurrentCard;
        this.argumentProvider = argumentProvider;
        this.setFlipManager(flipManager);
    }

    @Override
    public FlipManager getFlipManager() {
        return this.flipManager;
    }

    public void setFlipManager(FlipManager flipManager) {
        this.flipManager = flipManager;
        if (flipManager != null) {
            flipManager.addCardChangedListener(new CardChangedListener(){

                @Override
                public void cardSelected(Class<? extends CardPanel> panel) {
                    if (ShowScreenActionImpl.this.legacyPanelClass.isAssignableFrom(panel)) {
                        ShowScreenActionImpl.this.putValue("SwingSelectedKey", true);
                    }
                    this.updateEnablement();
                }

                private void updateEnablement() {
                    ShowScreenActionImpl.this.setEnabled(ShowScreenActionImpl.this.enablementRequested);
                }
            });
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enablementRequested = enabled;
        super.setEnabled(enabled && this.canEnable());
    }

    private boolean canEnable() {
        SwitchSupport switchSupport = this.getFlipManager().getSwitchSupport();
        boolean cardIsShowing = this.legacyPanelClass.isInstance(switchSupport.getCurrentCard());
        boolean cardIsOnStack = switchSupport.hasCardPanelInStack(this.legacyPanelClass);
        boolean disable = this.stackCurrentCard && (cardIsShowing || cardIsOnStack);
        return !disable;
    }

    @Override
    public void doActionPerformed(ActionEvent e) {
        this.performBefore();
        boolean result = this.stackCurrentCard ? this.flipManager.stackCurrentCardAndSwitchTo(this.legacyPanelClass, this.argumentProvider.argument()) : this.flipManager.switchTo(this.legacyPanelClass, this.argumentProvider.argument());
        if (!result) {
            SwitchSupport.notifyOfChange(this.flipManager.getCurrentCard().getClass(), true);
        }
    }

    protected void performBefore() {
    }

    @Override
    public Class<? extends CardPanel> getDestinationPanelType() {
        return this.legacyPanelClass;
    }
}

