/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.ur.lang.StringUtils;
import com.ur.swing.FormBuilder;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import com.ur.util.ArrayUtils;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class SwingFormBuilder
implements FormBuilder {
    private static final int ABOVE_AND_BELOW_ROW_SET = 2;
    private static final int ROW_AND_FILLER = 2;
    private static final int INDENT_SIZE = UIManager.getInt("Form.indentSize");
    private final List<List<Definition>> rows;
    private final WidgetFactory widgetFactory;
    private int columnCount;
    private int rowCount = 1;
    private int row = 1;
    private int col = 1;
    private final List<int[]> columnGroups = new ArrayList<int[]>();
    private final List<Integer> fixedSizeColumns = new ArrayList<Integer>();

    public SwingFormBuilder(WidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
        this.rows = new ArrayList<List<Definition>>();
        this.rows.add(new ArrayList());
        Object[] values = new Integer[30];
        Arrays.fill(values, (Object)-1);
        this.fixedSizeColumns.addAll(Arrays.asList(values));
    }

    private void resetPanelBuilder() {
        this.rows.clear();
        this.rows.add(new ArrayList());
        this.columnCount = 0;
        this.rowCount = 1;
        this.row = 1;
        this.col = 1;
        this.columnGroups.clear();
    }

    @Override
    public FormBuilder headerLabel(String headerText, FormBuilder.PanelConstraints ... constraints) {
        JLabel label = this.widgetFactory.createPageTitle(headerText);
        if (constraints.length == 0) {
            return this.addInternal(label, FormBuilder.PanelConstraints.SPAN_COLUMNS);
        }
        return this.addInternal(label, constraints);
    }

    @Override
    public FormBuilder columnTitle(String title, FormBuilder.PanelConstraints ... constraints) {
        JLabel label = this.widgetFactory.createColumnTitle(title);
        return this.addInternal(label, constraints);
    }

    @Override
    public FormBuilder description(String text, FormBuilder.PanelConstraints ... constraints) {
        return this.description(null, text, constraints);
    }

    @Override
    public FormBuilder description(Icon icon, String description, FormBuilder.PanelConstraints ... constraints) {
        JLabel label = this.widgetFactory.createLabel(HTML.html((String)description));
        label.setIcon(icon);
        label.setVerticalAlignment(1);
        return this.addInternal(label, constraints);
    }

    @Override
    public FormBuilder label(String text, FormBuilder.PanelConstraints ... constraints) {
        JLabel label = this.widgetFactory.createLabel(text);
        return this.addInternal(label, constraints);
    }

    @Override
    public FormBuilder label(JLabel label, FormBuilder.PanelConstraints ... constraints) {
        return this.addInternal(label, constraints);
    }

    @Override
    public FormBuilder label(Icon icon, String text, FormBuilder.PanelConstraints ... constraints) {
        JLabel label = this.widgetFactory.createLabel(text);
        label.setIcon(icon);
        return this.addInternal(label, constraints);
    }

    @Override
    public FormBuilder sectionHeader(String text, FormBuilder.PanelConstraints ... constraints) {
        JComponent separator = this.widgetFactory.createSeparator(text);
        return this.addInternal(separator, constraints);
    }

    @Override
    public FormBuilder component(JComponent component, FormBuilder.PanelConstraints ... constraints) {
        return this.addInternal(component, constraints);
    }

    @Override
    public FormBuilder components(FormBuilder.Components components, FormBuilder.PanelConstraints ... constraints) {
        components.addTo(this, constraints);
        return this;
    }

    @Override
    public FormBuilder componentWithLabel(String label, JComponent component, FormBuilder.PanelConstraints ... constraints) {
        this.addInternal(this.widgetFactory.createLabel(label), new FormBuilder.PanelConstraints[0]);
        this.addInternal(component, constraints);
        return this;
    }

    @Override
    public FormBuilder spacer() {
        return this.addInternal(new JLabel(""), new FormBuilder.PanelConstraints[0]);
    }

    @Override
    public FormBuilder spacer(int columnCount) {
        int i = 0;
        while (i < columnCount) {
            this.spacer();
            ++i;
        }
        return this;
    }

    @Override
    public FormBuilder end() {
        ++this.rowCount;
        this.rows.add(new ArrayList());
        return this;
    }

    @Override
    public FormBuilder end(int rowCount) {
        int i = 0;
        while (i < rowCount) {
            this.end();
            ++i;
        }
        return this;
    }

    @Override
    public FormBuilder buttonRow(Action action, FormBuilder.PanelConstraints ... constraints) {
        return this.buttonRow((JComponent)this.widgetFactory.createButton(action), constraints);
    }

    @Override
    public FormBuilder buttonRow(Action action1, Action action2, FormBuilder.PanelConstraints ... constraints) {
        JButton button1 = this.widgetFactory.createButton(action1);
        JButton button2 = this.widgetFactory.createButton(action2);
        return this.buttonRow((JComponent)button1, (JComponent)button2, constraints);
    }

    @Override
    public FormBuilder buttonRow(Action action1, Action action2, Action action3, FormBuilder.PanelConstraints ... constraints) {
        JButton button1 = this.widgetFactory.createButton(action1);
        JButton button2 = this.widgetFactory.createButton(action2);
        JButton button3 = this.widgetFactory.createButton(action3);
        return this.buttonRow((JComponent)button1, (JComponent)button2, button3, constraints);
    }

    @Override
    public FormBuilder buttonRow(JComponent button, FormBuilder.PanelConstraints ... constraints) {
        ButtonBarBuilder buttonBarBuilder = this.createButtonBarBuilder(constraints).addButton(button);
        return this.buildButtonBar(buttonBarBuilder, constraints);
    }

    @Override
    public FormBuilder buttonRow(JComponent button1, JComponent button2, FormBuilder.PanelConstraints ... constraints) {
        ButtonBarBuilder buttonBarBuilder = this.createButtonBarBuilder(constraints).addButton(button1).addStrut(new ConstantSize(4, ConstantSize.DLUX)).addButton(button2);
        return this.buildButtonBar(buttonBarBuilder, constraints);
    }

    @Override
    public FormBuilder buttonRow(JComponent button1, JComponent button2, JComponent button3, FormBuilder.PanelConstraints ... constraints) {
        ButtonBarBuilder buttonBarBuilder = this.createButtonBarBuilder(constraints).addButton(button1).addStrut(new ConstantSize(4, ConstantSize.DLUX)).addButton(button2).addStrut(new ConstantSize(4, ConstantSize.DLUX)).addButton(button3);
        return this.buildButtonBar(buttonBarBuilder, constraints);
    }

    @Override
    public FormBuilder groupColumns(int ... columnIndex) {
        this.columnGroups.add(columnIndex);
        return this;
    }

    @Override
    public FormBuilder fixedSizeColumnAndWidthPairs(int ... columnIndicesAndWidth) {
        int i = 0;
        while (i < columnIndicesAndWidth.length) {
            this.fixedSizeColumns.set(columnIndicesAndWidth[i], columnIndicesAndWidth[i + 1]);
            i += 2;
        }
        return this;
    }

    @Override
    public JPanel getCardPanel(String title) {
        JPanel result = this.getPanel();
        Border innerBorder = result.getBorder();
        if (StringUtils.isNullOrOnlyWhitespace((String)title)) {
            result.setBorder(innerBorder);
        } else {
            result.setBorder(new CompoundBorder(new CardBorder(title), innerBorder));
        }
        return result;
    }

    @Override
    public JPanel getRow() {
        JPanel result = new JPanel();
        FormLayout formLayout = new FormLayout("0" + this.generateColumns().substring(1) + " 0dlu", "0" + this.generateRows().substring(1) + " 0dlu");
        formLayout.setColumnGroups(this.matchAllColumns(this.columnCount));
        result.setLayout((LayoutManager)formLayout);
        result.setBorder(BorderFactory.createEmptyBorder());
        Log.debug((String)("column count: (" + this.columnCount + ")"));
        this.buildPanel(result);
        this.resetPanelBuilder();
        return result;
    }

    @Override
    public JPanel getPanel() {
        JPanel result = this.columnGroups.isEmpty() ? this.createJPanel(new JPanel()) : this.createJPanelMatchingColumns(new JPanel(), this.columnGroups);
        result.setBorder(new EmptyBorder(15, 10, 5, 10));
        Log.debug((String)("dimension: (" + this.rowCount + ", " + this.columnCount + ")"));
        this.buildPanel(result);
        this.resetPanelBuilder();
        return result;
    }

    @Override
    public void setOnPanel(JPanel panel) {
        JPanel result = this.columnGroups.isEmpty() ? this.createJPanel(panel) : this.createJPanelMatchingColumns(panel, this.columnGroups);
        result.setBorder(new EmptyBorder(15, 10, 5, 10));
        Log.debug((String)("dimension: (" + this.rowCount + ", " + this.columnCount + ")"));
        this.buildPanel(result);
        this.resetPanelBuilder();
    }

    private void buildPanel(JPanel result) {
        for (List<Definition> eachRow : this.rows) {
            String debug = "Building row: (" + this.row;
            for (Definition eachDefinition : eachRow) {
                if (eachDefinition == null) continue;
                debug = String.valueOf(debug) + ", " + eachDefinition.component.getClass().getName();
                CellConstraints rcwh = this.createConstraints(eachDefinition.constraints);
                result.add((Component)eachDefinition.component, rcwh);
            }
            debug = String.valueOf(debug) + ")";
            Log.debug((String)debug);
            this.col = 1;
            ++this.row;
        }
    }

    private JPanel createJPanelMatchingColumns(JPanel panel, List<int[]> columnCnstraints) {
        int[][] result = new int[columnCnstraints.size()][];
        int i = 0;
        for (int[] each : columnCnstraints) {
            result[i] = new int[each.length];
            int j = 0;
            while (j < each.length) {
                result[i][j] = each[j] * 2;
                ++j;
            }
            ++i;
        }
        String columnsSpec = String.valueOf(this.generateColumns()) + "2dlu";
        String rowsSpec = String.valueOf(this.generateRows()) + "1dlu";
        FormLayout formLayout = new FormLayout(columnsSpec, rowsSpec);
        formLayout.setColumnGroups((int[][])result);
        panel.setLayout((LayoutManager)formLayout);
        return panel;
    }

    private String generateColumns() {
        StringBuilder result = new StringBuilder();
        int i = 1;
        while (i <= this.columnCount) {
            if (this.fixedSizeColumns.get(i) != -1) {
                int widthValue = this.fixedSizeColumns.get(i);
                result.append("2dlu, " + widthValue + "dlu:grow(0.0) , ");
            } else {
                result.append("2dlu, pref:grow(1.0), ");
            }
            ++i;
        }
        return result.toString();
    }

    private String generateRows() {
        String result = "";
        int rowsToSkip = 0;
        int i = 0;
        while (i < this.rowCount) {
            FormBuilder.PanelConstraints[] constraints;
            List<Definition> row = this.rows.get(i);
            if (rowsToSkip > 0) {
                --rowsToSkip;
            }
            if (row.size() == 1 && ArrayUtils.contains((Object)((Object)FormBuilder.PanelConstraints.SPAN_COLUMNS), (Object[])(constraints = row.get((int)0).constraints))) {
                rowsToSkip = this.spanRowCount(constraints);
            }
            result = !row.isEmpty() && this.isPanelOfButtons(row.get(0)) ? String.valueOf(result) + "1dlu, fill:28dlu, " : (row.isEmpty() && rowsToSkip == 0 ? String.valueOf(result) + "1dlu, fill:10dlu, " : (this.hasContainsConstraintInRow(FormBuilder.PanelConstraints.BUTTON_ROW, row) ? String.valueOf(result) + "1dlu, fill:24dlu, " : String.valueOf(result) + "1dlu, fill:16dlu, "));
            ++i;
        }
        return result;
    }

    private boolean hasContainsConstraintInRow(FormBuilder.PanelConstraints constraint, List<Definition> row) {
        for (Definition each : row) {
            if (each == null || !ArrayUtils.contains((Object)((Object)constraint), (Object[])each.constraints)) continue;
            return true;
        }
        return false;
    }

    private boolean isPanelOfButtons(Definition definition) {
        boolean result = definition.component instanceof JPanel;
        int i = 0;
        while (i < definition.component.getComponentCount()) {
            if (!(definition.component.getComponent(i) instanceof AbstractButton)) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    private JPanel createJPanel(JPanel panel) {
        FormLayout formLayout = new FormLayout(String.valueOf(this.generateColumns()) + "2dlu", String.valueOf(this.generateRows()) + "1dlu");
        formLayout.setColumnGroups(this.matchAllColumns(this.columnCount));
        panel.setLayout((LayoutManager)formLayout);
        return panel;
    }

    private int[][] matchAllColumns(int columnCount) {
        int[][] result = new int[1][columnCount];
        int i = 0;
        while (i < columnCount) {
            result[0][i] = (i + 1) * 2;
            ++i;
        }
        return result;
    }

    private ButtonBarBuilder createButtonBarBuilder(FormBuilder.PanelConstraints ... constraints) {
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        if (!ArrayUtils.contains((Object)((Object)FormBuilder.PanelConstraints.LEFT_ALIGN), (Object[])constraints)) {
            buttonBarBuilder.addGlue();
        }
        return buttonBarBuilder;
    }

    private FormBuilder buildButtonBar(ButtonBarBuilder buttonBarBuilder, FormBuilder.PanelConstraints ... constraints) {
        if (constraints.length == 0) {
            return this.addInternal(buttonBarBuilder.build(), FormBuilder.PanelConstraints.SPAN_COLUMNS);
        }
        if (constraints.length == 1 && constraints[0] == FormBuilder.PanelConstraints.LEFT_ALIGN) {
            return this.addInternal(buttonBarBuilder.build(), FormBuilder.PanelConstraints.SPAN_COLUMNS);
        }
        return this.addInternal(buttonBarBuilder.build(), constraints);
    }

    private SwingFormBuilder addInternal(JComponent component, FormBuilder.PanelConstraints ... constraints) {
        int i;
        if (component instanceof JLabel && ArrayUtils.contains((Object)((Object)FormBuilder.PanelConstraints.CENTER), (Object[])constraints)) {
            ((JLabel)component).setHorizontalAlignment(0);
        }
        this.rows.get(this.rowCount - 1).add(new Definition(component, constraints));
        int spanColCount = this.spanColumnCount(constraints);
        int spanRowCount = this.spanRowCount(constraints);
        if (spanColCount > 1) {
            i = 0;
            while (i < spanColCount - 1) {
                this.rows.get(this.rowCount - 1).add(null);
                ++i;
            }
        }
        if (this.columnCount < this.rows.get(this.rowCount - 1).size()) {
            this.columnCount = this.rows.get(this.rowCount - 1).size();
        }
        if (spanRowCount > 1) {
            i = 0;
            while (i < spanRowCount - 1) {
                this.rows.add(new ArrayList());
                ++i;
            }
            if (ArrayUtils.contains((Object)((Object)FormBuilder.PanelConstraints.SPAN_COLUMNS), (Object[])constraints)) {
                this.rowCount = this.rows.size();
            }
        }
        return this;
    }

    private CellConstraints createConstraints(FormBuilder.PanelConstraints ... constraints) {
        CellConstraints rcwh;
        int spanRows = this.spanRowCount(constraints);
        int spanColumns = this.spanColumnCount(constraints);
        if (spanRows > 1) {
            spanRows = spanRows * 2 + 2;
        }
        int row = this.row;
        if (spanColumns > 1) {
            rcwh = CC.rchw((int)(2 * row), (int)(2 * this.col), (int)spanRows, (int)(spanColumns * 2));
            this.col += this.spanColumnCount(constraints);
        } else if (this.hasSpanColumns(constraints)) {
            rcwh = CC.rchw((int)(2 * row), (int)(2 * this.col), (int)spanRows, (int)((this.columnCount - this.col + 1) * 2 - 1));
            if (this.col == 1) {
                row += this.spanRowCount(constraints);
            } else {
                this.col = this.columnCount + 1;
            }
        } else {
            rcwh = CC.rchw((int)(2 * row), (int)(2 * this.col), (int)spanRows, (int)1);
            ++this.col;
        }
        if (ArrayUtils.contains((Object)((Object)FormBuilder.PanelConstraints.INDENT), (Object[])constraints)) {
            rcwh.insets = new Insets(0, INDENT_SIZE, 0, 0);
        }
        return rcwh;
    }

    private int spanRowCount(FormBuilder.PanelConstraints[] constraints) {
        if (ArrayUtils.contains((Object)((Object)FormBuilder.PanelConstraints.FILL_ROWS), (Object[])constraints)) {
            return this.rowCount - this.row;
        }
        FormBuilder.PanelConstraints rowHeight = this.getType(0, constraints);
        if (rowHeight == null) {
            return 1;
        }
        return rowHeight.value;
    }

    private int spanColumnCount(FormBuilder.PanelConstraints[] constraints) {
        FormBuilder.PanelConstraints columnsWidth = this.getType(1, constraints);
        if (columnsWidth == null) {
            return 1;
        }
        return columnsWidth.value;
    }

    private FormBuilder.PanelConstraints getType(int lookup, FormBuilder.PanelConstraints[] constraints) {
        FormBuilder.PanelConstraints[] panelConstraintsArray = constraints;
        int n = constraints.length;
        int n2 = 0;
        while (n2 < n) {
            FormBuilder.PanelConstraints each = panelConstraintsArray[n2];
            if (each.type == lookup) {
                return each;
            }
            ++n2;
        }
        return null;
    }

    private boolean hasSpanColumns(FormBuilder.PanelConstraints[] constraints) {
        return ArrayUtils.contains((Object)((Object)FormBuilder.PanelConstraints.SPAN_COLUMNS), (Object[])constraints);
    }

    public static void main(String[] args) {
    }

    public class Definition {
        final JComponent component;
        final FormBuilder.PanelConstraints[] constraints;

        public Definition(JComponent component, FormBuilder.PanelConstraints[] constraints) {
            this.component = component;
            this.constraints = constraints;
        }
    }
}

