/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.ToolbarBuilder;
import com.ur.swing.WidgetFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;

public class SwingToolbarBuilder
implements ToolbarBuilder {
    private static final Insets INSETS = new Insets(0, 0, 0, 0);
    private static final int Y_GRID_POSITION = 0;
    private final Container container;
    private final WidgetFactory widgetFactory;
    private int xGridPosition;

    public SwingToolbarBuilder(Container container, WidgetFactory widgetFactory) {
        this.container = container;
        container.setLayout(new GridBagLayout());
        if (container instanceof JComponent) {
            ((JComponent)container).setBorder(BorderFactory.createEmptyBorder());
        }
        this.widgetFactory = widgetFactory;
    }

    @Override
    public ToolbarBuilder add(Action action) {
        JButton button = this.widgetFactory.createButton(action);
        this.add(button);
        return this;
    }

    @Override
    public ToolbarBuilder addSection(Action ... actionsToContribute) {
        JComponent[] buttons = new AbstractButton[actionsToContribute.length];
        int i = 0;
        while (i < buttons.length) {
            buttons[i] = this.widgetFactory.createButton(actionsToContribute[i]);
            ++i;
        }
        this.addSection(buttons);
        return this;
    }

    @Override
    public ToolbarBuilder addSection(JComponent ... components) {
        if (this.container.getComponentCount() > 0) {
            this.container.add((Component)Box.createHorizontalBox(), this.createConstraintsWithWeight(1.0));
        }
        JComponent[] jComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent each = jComponentArray[n2];
            this.container.add((Component)each, this.createConstraintsWithWeight(0.0));
            ++n2;
        }
        return this;
    }

    @Override
    public ToolbarBuilder add(JComponent component) {
        if (this.container.getComponentCount() > 0) {
            this.container.add((Component)Box.createHorizontalBox(), this.createConstraintsWithWeight(1.0));
        }
        this.container.add((Component)component, this.createConstraintsWithWeight(0.0));
        return this;
    }

    @Override
    public ToolbarBuilder addSpacer() {
        this.container.add((Component)Box.createHorizontalBox(), this.createConstraintsWithWeight(1.0));
        return this;
    }

    @Override
    public void toLeft() {
        this.container.add((Component)Box.createHorizontalBox(), this.createConstraintsWithWeight(1.0));
    }

    private GridBagConstraints createConstraintsWithWeight(double weight) {
        return new GridBagConstraints(this.xGridPosition++, 0, 1, 1, weight, weight, 10, 1, INSETS, 0, 0);
    }
}

