/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.lang.EqualsUtil;
import com.ur.util.logging.Log;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SwingUtil {
    private SwingUtil() {
    }

    public static boolean isUiOrEventThread() {
        return SwingUtilities.isEventDispatchThread() || Thread.currentThread().getName().startsWith("AWT-EventQueue-");
    }

    public static <T> FutureTask<T> invokeLater(Callable<T> callable) {
        FutureTask<T> task = new FutureTask<T>(callable);
        SwingUtilities.invokeLater(task);
        return task;
    }

    public static <T> T invokeAndWaitForAnswer(Callable<T> callable) {
        return SwingUtil.invokeAndWaitForAnswer(new FutureTask<T>(callable), null);
    }

    public static <T> T invokeAndWaitForAnswer(FutureTask<T> request, T defaultAnswer) {
        SwingUtil.invokeAndWait(request);
        try {
            return request.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Log.warning((String)"Execution was interrupted: ", (Throwable)e);
        }
        catch (ExecutionException e) {
            Log.warning((String)"Failed to execute program: ", (Throwable)e);
        }
        catch (TimeoutException e) {
            Log.warning((String)"Failed with Timeout to execute program: ", (Throwable)e);
        }
        return defaultAnswer;
    }

    public static void invokeAndWait(Runnable runnable) {
        if (SwingUtil.isUiOrEventThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                throw new InvocationWasInterrupted(e);
            }
        }
    }

    public static FutureTask<Runnable> invokeLater(Runnable runnable) {
        FutureTask<Runnable> task = new FutureTask<Runnable>(runnable, runnable);
        SwingUtilities.invokeLater(task);
        return task;
    }

    private static boolean isSupportedType(Object object, Class<?> ... componentTypes) {
        Class<?>[] classArray = componentTypes;
        int n = componentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            if (type.isInstance(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int getComponentIndex(Container container, Component component) {
        Component[] subComponents = container.getComponents();
        int i = 0;
        while (i < subComponents.length) {
            if (subComponents[i].equals(component)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static List<Component> getAllComponents(Container parentContainer, Class<?> ... componentTypes) {
        Component[] subComponents = parentContainer.getComponents();
        ArrayList<Component> componentReturnList = new ArrayList<Component>();
        Component[] componentArray = subComponents;
        int n = subComponents.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (componentTypes.length == 0 || SwingUtil.isSupportedType(comp, componentTypes)) {
                componentReturnList.add(comp);
            }
            if (comp instanceof Container) {
                componentReturnList.addAll(SwingUtil.getAllComponents((Container)comp, componentTypes));
            }
            ++n2;
        }
        return componentReturnList;
    }

    public static Component makeFlowPanel(JComponent ... components) {
        JPanel result = new JPanel();
        result.setLayout(new FlowLayout());
        JComponent[] jComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent each = jComponentArray[n2];
            result.add(each);
            ++n2;
        }
        return result;
    }

    public static JFrame getJFrameFor(Component component) {
        return SwingUtil.getContainerOfType(JFrame.class, component);
    }

    public static <T> T getContainerOfType(Class<T> clazz, Component component) {
        while (!clazz.isInstance(component)) {
            if ((component = component.getParent()) == null) break;
        }
        return (T)(clazz.isInstance(component) ? component : null);
    }

    public static <T extends JComponent> T getComponentByName(Class<T> clazz, JComponent fromNode, String name) {
        for (Component each : SwingUtil.getAllComponents(fromNode, clazz)) {
            if (!EqualsUtil.equals((Object)each.getName(), (Object)name)) continue;
            return (T)((JComponent)each);
        }
        return null;
    }

    public static void setEnabledRecursive(Container container, boolean enable, List<Component> componentsToggled, String ... exceptions) {
        List<String> exceptionsList = Arrays.asList(exceptions);
        SwingUtil.toggleComponent(container, enable, componentsToggled, exceptionsList);
        SwingUtil.setEnabledChildren(container, enable, componentsToggled, exceptionsList);
    }

    private static void setEnabledChildren(Container container, boolean enable, List<Component> componentsToggled, List<String> exceptions) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            SwingUtil.toggleComponent(component, enable, componentsToggled, exceptions);
            if (component instanceof Container) {
                SwingUtil.setEnabledChildren((Container)component, enable, componentsToggled, exceptions);
            }
            ++n2;
        }
    }

    private static void toggleComponent(Component component, boolean enable, List<Component> componentsToggled, List<String> exceptions) {
        if (component.isEnabled() != enable && !exceptions.contains(component.getName())) {
            component.setEnabled(enable);
            if (!componentsToggled.contains(component)) {
                componentsToggled.add(component);
            }
        }
    }

    public static void setEnabledComponents(List<Component> components, boolean enable) {
        for (Component component : components) {
            component.setEnabled(enable);
        }
    }

    public static class InvocationWasInterrupted
    extends RuntimeException {
        public InvocationWasInterrupted(Exception e) {
            super(e);
        }
    }
}

