/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.injection.Builder;
import com.ur.swing.FormBuilder;
import com.ur.swing.SwingFormBuilder;
import com.ur.swing.SwingToolbarBuilder;
import com.ur.swing.ToolbarBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.AggregateDialogCreator;
import com.ur.swing.help.HelpIdAssignerExt;
import com.ur.swing.i18n.LocalizationResource;
import java.awt.Container;
import javax.inject.Inject;

public class SwingViewContext
implements ViewContext {
    private final URFontFactory fontFactory;
    private final WidgetFactory widgetFactory;
    private final Builder builder;

    @Inject
    public SwingViewContext(URFontFactory fontFactory, WidgetFactory widgetFactory, Builder builder) {
        this.fontFactory = fontFactory;
        this.widgetFactory = widgetFactory;
        this.builder = builder;
    }

    @Override
    public ToolbarBuilder createToolBarBuilder(Container container) {
        return new SwingToolbarBuilder(container, this.createWidgetFactory());
    }

    @Override
    public FormBuilder createFormBuilder() {
        return new SwingFormBuilder(this.widgetFactory);
    }

    @Override
    public WidgetFactory createWidgetFactory() {
        return this.widgetFactory;
    }

    @Override
    public <T extends LocalizationResource> T getTextResource(Class<T> textResource) {
        return (T)((LocalizationResource)this.builder.get(textResource));
    }

    @Override
    public AggregateDialogCreator getDialogCreator() {
        return (AggregateDialogCreator)this.builder.get(AggregateDialogCreator.class);
    }

    @Override
    public URFontFactory getFontFactory() {
        return this.fontFactory;
    }

    @Override
    public HelpIdAssignerExt getHelpIdAssigner() {
        return (HelpIdAssignerExt)this.builder.get(HelpIdAssignerExt.class);
    }
}

