/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.jgoodies.forms.factories.ComponentFactory;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.ur.lang.Defense;
import com.ur.lang.StringUtils;
import com.ur.swing.ActionDefinition;
import com.ur.swing.BaseView;
import com.ur.swing.ComboBox;
import com.ur.swing.ComboBoxWithErrorBorder;
import com.ur.swing.FontFactory;
import com.ur.swing.GuiUtilities;
import com.ur.swing.IconAndLabelProvider;
import com.ur.swing.IconProvider;
import com.ur.swing.InputField;
import com.ur.swing.LabelProvider;
import com.ur.swing.LongPressButton;
import com.ur.swing.MouseEventActionWrapper;
import com.ur.swing.TableUtils;
import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.swing.URFontFactory;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.DialogOnScreen;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.DefaultComboBoxRenderer;
import com.ur.swing.g5.EnablementMatteBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.number.NumberField;
import com.ur.swing.number.NumberFieldBorderable;
import com.ur.swing.resources.LogoImageResource;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.units.ValueConverter;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jdesktop.swingx.HorizontalLayout;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.border.DropShadowBorder;

public class SwingWidgetFactory
implements WidgetFactory {
    private static final Color SELECTED_HEADER_BACKGROUND = G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE;
    private static final Dimension PASSWORD_DIMENSIONS = new Dimension(140, 31);
    private static Icon scaledURLogoCache = null;
    private final ComponentFactory componentFactory = new DefaultComponentFactory();
    private final URFontFactory fontFactory;
    private final DialogOnScreen dialogOnScreen;
    private final HelpIdAssigner helpIdAssigner;

    public SwingWidgetFactory() {
        this(new FontFactory(), () -> false, (c, id) -> {});
    }

    @Inject
    public SwingWidgetFactory(URFontFactory fontFactory, DialogOnScreen dialogOnScreen, HelpIdAssigner helpIdAssigner) {
        this.fontFactory = fontFactory;
        this.dialogOnScreen = dialogOnScreen;
        this.helpIdAssigner = helpIdAssigner;
    }

    @Override
    public JMenu createMenu(String name, Icon icon) {
        JMenu menu = new JMenu(name);
        if (icon != null) {
            menu.setIcon(icon);
        }
        menu.setVerticalTextPosition(3);
        menu.setHorizontalTextPosition(0);
        menu.setFont(this.fontFactory.getRelativeFont(URFontFactory.Size.TINY));
        return menu;
    }

    @Override
    public JMenuItem createMenuButton(Action action) {
        JMenuItem result = new JMenuItem(action);
        this.createButtonFunction(result, action);
        result.getModel().addChangeListener(e -> {
            if (e.getSource() instanceof ButtonModel) {
                ButtonModel item = (ButtonModel)e.getSource();
                if (item.isSelected() || item.isArmed()) {
                    Icon selectedIcon = (Icon)action.getValue("SelectedSmallIcon");
                    if (selectedIcon != null) {
                        result.setIcon(selectedIcon);
                    }
                } else {
                    result.setIcon((Icon)action.getValue("SmallIcon"));
                }
            }
        });
        return result;
    }

    @Override
    public JButton createButton(Action action) {
        JButton result = action instanceof MouseListener ? new MouseListenerButton(action) : new JButton(action);
        this.createButtonFunction(result, action);
        result.setUI(new ButtonLookAndFeelUI(action));
        return result;
    }

    @Override
    public JToggleButton createToggleButton(Action action) {
        JToggleButton result = new JToggleButton(action);
        this.createButtonFunction(result, action);
        action.addPropertyChangeListener(evt -> {
            if ("SelectedSmallIcon".equals(evt.getPropertyName()) && result.isSelected()) {
                result.setIcon((Icon)evt.getNewValue());
            }
        });
        result.setUI(new ToggleButtonLookAndFeelUI(action, SELECTED_HEADER_BACKGROUND));
        result.addItemListener(new ToggleButtonLookAndFeelItemListener(result, action));
        return result;
    }

    @Override
    public JRadioButton createRadioButton(Action action) {
        JRadioButton result = new JRadioButton(action);
        this.createButtonFunction(result, action);
        return result;
    }

    @Override
    public JCheckBox createCheckBox(String setTCP) {
        return new JCheckBox(setTCP);
    }

    @Override
    public AbstractButton createHiddenPress(AbstractButton button, Action hiddenAction) {
        LongPressButton longPressButton = new LongPressButton(this.dialogOnScreen);
        return longPressButton.addLongPressAction(button, hiddenAction, 1200);
    }

    @Override
    public AbstractButton createButtonFunction(AbstractButton button) {
        Defense.notNull((Object)button.getAction(), (String)"Action cannot be null on the button");
        this.createButtonFunction(button, button.getAction());
        return button;
    }

    @Override
    public JPanel createInfoMessagePanel(String informationText) {
        return SwingWidgetFactory.createMessagePanel(informationText, G5LookAndFeel.INFO_BORDER_COLOR, G5LookAndFeel.INFO_FILL_COLOR);
    }

    @Override
    public JPanel createWarningMessagePanel(String warningText) {
        return SwingWidgetFactory.createMessagePanel(warningText, G5LookAndFeel.WARNING_BORDER_COLOR, G5LookAndFeel.WARNING_FILL_COLOR);
    }

    @Override
    public JPanel createErrorMessagePanel(String errorText) {
        return SwingWidgetFactory.createMessagePanel(errorText, G5LookAndFeel.ERROR_BORDER_COLOR, G5LookAndFeel.ERROR_FILL_COLOR);
    }

    private static JPanel createMessagePanel(String text, Color borderColor, Color backgroundColor) {
        JPanel messagePanel = new JPanel();
        messagePanel.add(new JLabel(text));
        messagePanel.setBackground(backgroundColor);
        messagePanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, borderColor));
        return messagePanel;
    }

    public void createButtonFunction(AbstractButton result, Action action) {
        String name;
        String helpId;
        ActionDefinition.Function value = (ActionDefinition.Function)((Object)action.getValue("Function"));
        result.setFocusPainted(false);
        if (value != null) {
            switch (value) {
                case TOOLBAR: {
                    result.setOpaque(false);
                    result.setBorder(new EmptyBorder(5, 5, 5, 5));
                    result.setSize(32, 32);
                    break;
                }
                case TOOLBAR_VIEW_HEADER: {
                    result.setVerticalTextPosition(3);
                    result.setHorizontalTextPosition(0);
                    result.setFont(this.fontFactory.getRelativeFont(URFontFactory.Size.SMALL));
                    break;
                }
                case APPLICATION_HEADER: {
                    result.setSize(64, 64);
                    result.setVerticalTextPosition(3);
                    result.setHorizontalTextPosition(0);
                    result.setFont(this.fontFactory.getRelativeFont(URFontFactory.Size.TINY));
                    result.setForeground(Color.WHITE);
                    result.setBackground(UIManager.getColor("header.background"));
                    result.setBorder(BorderFactory.createEmptyBorder());
                    break;
                }
                case APPLICATION_FOOTER: {
                    result.setPreferredSize(new Dimension(64, 64));
                    result.setVerticalTextPosition(1);
                    result.setHorizontalTextPosition(0);
                    result.setFont(this.fontFactory.getRelativeFont(URFontFactory.Size.TINY));
                    result.setForeground(Color.WHITE);
                    result.setBackground(UIManager.getColor("header.background"));
                    result.setBorder(BorderFactory.createEmptyBorder());
                    break;
                }
                case SECTION_HEADER: {
                    result.setBackground(UIManager.getColor("AccordionView.headerBackground"));
                    result.setForeground(UIManager.getColor("AccordionView.headerForeground"));
                    result.setPreferredSize(new Dimension(180, 35));
                    result.setBorder(BorderFactory.createEmptyBorder());
                    break;
                }
                case SUB_SECTION_HEADER: {
                    result.setBackground(UIManager.getColor("AccordionView.subSectionBackground"));
                    int dimensionsY = this.getDimensions(action);
                    result.setPreferredSize(new Dimension(180, dimensionsY));
                    result.setBorder(UIManager.getBorder("AccordionView.subSectionBorder"));
                    break;
                }
                case POPUP_MENU_ITEM: {
                    result.setBackground(UIManager.getColor("AccordionView.headerBackground"));
                    result.setForeground(UIManager.getColor("AccordionView.headerForeground"));
                    result.setPreferredSize(new Dimension(180, 45));
                    result.setBorder(BorderFactory.createEmptyBorder());
                    break;
                }
                case PRIMARY: {
                    result.setBackground(UIManager.getColor("Button.primaryBackgroundColor"));
                    break;
                }
                case SECONDARY: {
                    break;
                }
                case PRIMARY_INLINE_ACTION: {
                    result.setBackground(UIManager.getColor("Button.primaryBackgroundColor"));
                    result.setBorder(new CompoundBorder(new EnablementMatteBorder(2, 2, 2, 2, UIManager.getColor("Button.primaryBackgroundColor"), Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
                    break;
                }
                case INLINE_ACTION: {
                    result.setBorder(new CompoundBorder(new EnablementMatteBorder(2, 2, 2, 2, UIManager.getColor("selectedWidget"), Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
                    break;
                }
                case WIZARD: {
                    break;
                }
            }
        }
        if ((helpId = (String)action.getValue("HelpId")) != null) {
            this.helpIdAssigner.assignHelpId(result, helpId);
        }
        if ((name = (String)action.getValue("InternalName")) != null) {
            result.setName(name);
        }
    }

    private int getDimensions(Action contributedAction) {
        String name = (String)contributedAction.getValue("Name");
        if (StringUtils.isNullOrEmpty((String)name)) {
            return 25;
        }
        return name.contains("<br") ? 50 : 35;
    }

    @Override
    public JLabel createPageTitle(String text) {
        JLabel result = new JLabel(HTML.html((String)HTML.h1((String)text)));
        result.setFont(result.getFont().deriveFont(1, 18.0f));
        return result;
    }

    @Override
    public JLabel createColumnTitle(String title) {
        JLabel result = new JLabel(title);
        result.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        return result;
    }

    @Override
    public JLabel createURLogo() {
        if (scaledURLogoCache == null) {
            scaledURLogoCache = SwingWidgetFactory.scaleToHeight(LogoImageResource.asResource(LogoImageResource.universalRobots()), 50);
        }
        JLabel result = new JLabel();
        result.setIcon(scaledURLogoCache);
        result.setBorder(BorderFactory.createEmptyBorder());
        return result;
    }

    @Override
    public JLabel createSectionHeader(String text) {
        JLabel result = new JLabel(text);
        result.setFont(result.getFont().deriveFont(1, 12.0f));
        return result;
    }

    @Override
    public JComponent createSeparator(String text) {
        return this.componentFactory.createSeparator(text, 2);
    }

    @Override
    public JComponent createSeparator(Color color) {
        JComponent result = this.componentFactory.createSeparator("", 2);
        result.setForeground(color);
        result.setBackground(color);
        return result;
    }

    public JComponent createHeaderContribution(Action action) {
        return new JButton(action);
    }

    @Override
    public JPasswordField createPasswordField(String name) {
        final JPasswordField newPasswordField = new JPasswordField();
        newPasswordField.setName(name);
        newPasswordField.setPreferredSize(PASSWORD_DIMENSIONS);
        newPasswordField.setMaximumSize(PASSWORD_DIMENSIONS);
        newPasswordField.setMinimumSize(PASSWORD_DIMENSIONS);
        TextFieldUtils.bindTextPicker(newPasswordField, new TextHolder(){

            @Override
            public String getText() {
                return "";
            }

            @Override
            public void setText(String text) {
                newPasswordField.setText(text);
            }
        });
        return newPasswordField;
    }

    @Override
    public JPasswordField createPasswordField(String name, DocumentListener documentListener) {
        JPasswordField newPasswordField = this.createPasswordField(name);
        newPasswordField.getDocument().addDocumentListener(documentListener);
        return newPasswordField;
    }

    @Override
    public JLabel createURL(String text) {
        JLabel result = new JLabel("<html><h3><u>" + text + "</u></h3></html>");
        result.setHorizontalAlignment(2);
        result.setForeground(new Color(51, 153, 255));
        result.setFont(this.fontFactory.getRelativeFont(URFontFactory.Typeface.MONOSPACED, URFontFactory.Style.BOLD, URFontFactory.Size.LARGE));
        return result;
    }

    @Override
    public JLabel createLabel(Icon contents) {
        JLabel result = new JLabel(contents);
        result.setHorizontalAlignment(2);
        return result;
    }

    @Override
    public JLabel createLabel(String text) {
        JLabel result = new JLabel(HTML.html((String)text));
        result.setHorizontalAlignment(2);
        return result;
    }

    @Override
    public JPanel createTitleValuePair(String title, JLabel value) {
        Font titleFont = this.fontFactory.getRelativeFont(URFontFactory.Typeface.SANS_SERIF, URFontFactory.Size.VERY_SMALL);
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(new EmptyBorder(0, 8, 0, 8));
        JLabel titleLabel = new JLabel();
        titleLabel.setFont(titleFont);
        titleLabel.setForeground(Color.GRAY);
        titleLabel.setText(title);
        titleLabel.setHorizontalAlignment(0);
        result.add((Component)titleLabel, "North");
        value.setHorizontalAlignment(0);
        result.add((Component)value, "Center");
        return result;
    }

    @Override
    public JPanel horizontalPanel(JComponent ... components) {
        JPanel result = new JPanel((LayoutManager)new HorizontalLayout(1));
        result.setOpaque(false);
        result.setBorder(BorderFactory.createEmptyBorder());
        JComponent[] jComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent each = jComponentArray[n2];
            result.add(each);
            ++n2;
        }
        return result;
    }

    @Override
    public JPanel verticalPanel(JComponent ... components) {
        JPanel result = this.verticalPanel(1);
        JComponent[] jComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent each = jComponentArray[n2];
            result.add(each);
            ++n2;
        }
        return result;
    }

    @Override
    public JPanel verticalPanel(int gap) {
        JPanel result = new JPanel((LayoutManager)new VerticalLayout(gap));
        result.setOpaque(false);
        result.setBorder(BorderFactory.createEmptyBorder());
        return result;
    }

    @Override
    public JPanel withTitle(JPanel panel, String title) {
        panel.setBorder(new CardBorder(title));
        return panel;
    }

    @Override
    public JPanel withTitle(JPanel panel, Icon icon, String title) {
        panel.setBorder(new CardBorder(icon, title));
        return panel;
    }

    @Override
    public JTextField createTextField() {
        final JTextField result = new JTextField("");
        result.setHorizontalAlignment(4);
        TextFieldUtils.bindTextPicker(result, new TextHolder(){

            @Override
            public String getText() {
                return result.getText();
            }

            @Override
            public void setText(String text) {
                result.setText(text);
            }
        });
        return result;
    }

    @Override
    public InputField createInputField(ActionListener listener) {
        InputField result = new InputField();
        result.addActionListener(listener);
        return result;
    }

    @Override
    public JTextArea createTextArea(String name) {
        JTextArea result = new JTextArea("");
        result.setName(name);
        return result;
    }

    @Override
    public NumberField createNumberField(String unit) {
        return new NumberField(unit);
    }

    @Override
    public NumberField createNumberField(ActionListener listener) {
        return this.createNumberField(listener, NumberFieldBorderable.DUMMY_CONVERTER);
    }

    @Override
    public NumberField createNumberField(ActionListener listener, ValueConverter converter) {
        NumberField result = new NumberField(converter);
        result.addActionListener(listener);
        return result;
    }

    @Override
    public NumberField createNumberField(ActionListener listener, ValueConverter converter, boolean allowEmptyValue) {
        NumberField result = new NumberField(converter, allowEmptyValue);
        result.addActionListener(listener);
        return result;
    }

    @Override
    public ComboBox createComboBox() {
        ComboBox result = new ComboBox();
        result.setRenderer(new DefaultComboBoxRenderer());
        return result;
    }

    @Override
    public <T> ComboBox createComboBox(final IconProvider<T> provider, T ... values) {
        ComboBox<T> result = new ComboBox<T>(new DefaultComboBoxModel<T>(values));
        result.setRenderer(new DefaultComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof String) {
                    this.setText("" + value);
                    this.setIcon(null);
                } else {
                    this.setText("" + value);
                    this.setIcon(provider.getIcon(value));
                }
                return this;
            }
        });
        return result;
    }

    @Override
    public <T> ComboBox createComboBox(final LabelProvider<T> provider, T ... values) {
        ComboBox<T> result = new ComboBox<T>(new DefaultComboBoxModel<T>(values));
        result.setRenderer(new DefaultComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof String) {
                    this.setText((String)value);
                } else {
                    this.setText(provider.getText(value));
                }
                return this;
            }
        });
        return result;
    }

    @Override
    public <T> ComboBox createComboBoxWithErrorBorder(LabelProvider<T> provider, T ... values) {
        return new ComboBoxWithErrorBorder<T>(provider, new DefaultComboBoxModel<T>(values));
    }

    @Override
    public <T> ComboBox createComboBox(final IconAndLabelProvider<T> provider, T ... values) {
        ComboBox<T> result = new ComboBox<T>(new DefaultComboBoxModel<T>(values));
        result.setRenderer(new DefaultComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof String) {
                    this.setText((String)value);
                    this.setIcon(null);
                } else {
                    this.setText(provider.getText(value));
                    this.setIcon(provider.getIcon(value));
                }
                if (this.getText() == null) {
                    return null;
                }
                return this;
            }
        });
        return result;
    }

    @Override
    public JTree createTree() {
        JTree result = new JTree();
        result.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("root")));
        result.setBorder(new EmptyBorder(0, 0, 0, 0));
        GuiUtilities.setFingerDragScroll(result);
        return result;
    }

    public JComponent createProgressBar() {
        return new JProgressBar();
    }

    @Override
    public JList createList() {
        JList result = new JList();
        result.setBorder(BorderFactory.createEmptyBorder());
        return result;
    }

    @Override
    public JTable createTable() {
        JTable result = new JTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (!this.isRowSelected(row)) {
                    c.setBackground(TableUtils.getRowColor(row));
                }
                return c;
            }
        };
        ((JLabel)((Object)result.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(2);
        result.setShowHorizontalLines(false);
        result.setShowVerticalLines(false);
        result.setIntercellSpacing(new Dimension(0, 0));
        result.getTableHeader().setReorderingAllowed(false);
        result.setFillsViewportHeight(true);
        result.setSelectionMode(0);
        result.getColumnModel().setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public int getLeadSelectionIndex() {
                return -1;
            }
        });
        return result;
    }

    @Override
    public JScrollPane scrollable(JComponent component) {
        JScrollPane result = new JScrollPane(component);
        result.setHorizontalScrollBarPolicy(30);
        result.setVerticalScrollBarPolicy(20);
        new URFingerDragScrollMouseListener(component);
        return new JScrollPane(component);
    }

    @Override
    public BaseView createTile() {
        BaseView result = new BaseView();
        result.setPreferredSize(new Dimension(365, 195));
        result.setBackground(new Color(230, 230, 230));
        result.setHeaderForeground(Color.WHITE);
        result.setHeaderBackground(G5LookAndFeel.DARK_DARK_GRAY);
        result.setBorder((Border)new DropShadowBorder(Color.lightGray, 2, 0.5f, 1, true, true, true, true));
        return result;
    }

    private static void updateIconLocation(ActionDefinition.Function value, JComponent b, Rectangle iconRect) {
        switch (value) {
            case SECTION_HEADER: 
            case SUB_SECTION_HEADER: 
            case POPUP_MENU_ITEM: {
                int startX = (35 - iconRect.width) / 2;
                int startY = (b.getHeight() - iconRect.height) / 2;
                iconRect.setLocation(b.getInsets().left + startX, startY);
            }
        }
    }

    private static void updateTextLocation(ActionDefinition.Function value, JComponent c, Rectangle textRect) {
        switch (value) {
            case SECTION_HEADER: 
            case SUB_SECTION_HEADER: 
            case POPUP_MENU_ITEM: {
                textRect.setLocation(c.getInsets().left + 35, 7);
            }
        }
    }

    private static Icon scaleToHeight(URL imageURL, int scaledHeight) {
        ImageIcon originalLogo = new ImageIcon(imageURL);
        double scale = (double)scaledHeight / (double)originalLogo.getIconHeight();
        int scaledWidth = (int)(scale * (double)originalLogo.getIconWidth());
        Image scaledLogo = originalLogo.getImage().getScaledInstance(scaledWidth, scaledHeight, 4);
        return new ImageIcon(scaledLogo);
    }

    public static void main(String[] args) {
        SwingWidgetFactory factory = new SwingWidgetFactory();
        JFrame frame = new JFrame();
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(factory.createSectionHeader("Demo of Widgets"));
        contentPane.add(factory.createTextField());
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    private static final class ButtonLookAndFeelUI
    extends MetalButtonUI {
        private final Action action;

        private ButtonLookAndFeelUI(Action action) {
            this.action = action;
        }

        @Override
        protected Color getSelectColor() {
            Color color = super.getSelectColor();
            ActionDefinition.Function value = (ActionDefinition.Function)((Object)this.action.getValue("Function"));
            if (value == ActionDefinition.Function.APPLICATION_HEADER) {
                color = G5LookAndFeel.DARK_DARK_GRAY;
            }
            return color;
        }

        @Override
        protected void paintIcon(Graphics g, JComponent b, Rectangle iconRect) {
            ActionDefinition.Function value = (ActionDefinition.Function)((Object)this.action.getValue("Function"));
            if (value != null) {
                SwingWidgetFactory.updateIconLocation(value, b, iconRect);
            }
            super.paintIcon(g, b, iconRect);
        }

        @Override
        protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
            ActionDefinition.Function value = (ActionDefinition.Function)((Object)this.action.getValue("Function"));
            if (value != null) {
                SwingWidgetFactory.updateTextLocation(value, c, textRect);
            }
            super.paintText(g, c, textRect, text);
        }
    }

    private static class MouseListenerButton
    extends JButton {
        public MouseListenerButton(Action action) {
            super(action);
        }

        @Override
        public void setAction(Action action) {
            if (action instanceof MouseListener) {
                this.addMouseListener((MouseListener)((Object)action));
            } else {
                this.addMouseListener(new MouseEventActionWrapper(action));
            }
            super.setAction(action);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (this.getAction() != null) {
                this.getAction().setEnabled(enabled);
            }
        }

        @Override
        public void processFocusEvent(FocusEvent e) {
            if (e.getID() == 1004) {
                JButton button = (JButton)e.getComponent();
                button.setEnabled(this.getAction().isEnabled());
                button.getModel().setPressed(false);
            }
        }
    }

    private static final class ToggleButtonLookAndFeelItemListener
    implements ItemListener {
        private final JToggleButton result;
        private final Action action;

        private ToggleButtonLookAndFeelItemListener(JToggleButton result, Action action) {
            this.result = result;
            this.action = action;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                this.selectedState();
            } else {
                this.unselectedState();
            }
        }

        private void selectedState() {
            if (this.action.getValue("SelectedSmallIcon") != null) {
                this.result.setIcon((Icon)this.action.getValue("SelectedSmallIcon"));
            }
        }

        private void unselectedState() {
            this.result.setIcon((Icon)this.action.getValue("SmallIcon"));
        }
    }

    public static final class ToggleButtonLookAndFeelUI
    extends MetalToggleButtonUI {
        private final Action action;
        private Color applicationHeaderColor;

        public ToggleButtonLookAndFeelUI(Action action, Color applicationHeaderColor) {
            this.action = action;
            this.applicationHeaderColor = applicationHeaderColor;
        }

        public void setApplicationHeaderColor(Color applicationHeaderColor) {
            this.applicationHeaderColor = applicationHeaderColor;
        }

        @Override
        protected Color getFocusColor() {
            return this.getSelectColor();
        }

        @Override
        protected Color getSelectColor() {
            Color color = super.getSelectColor();
            ActionDefinition.Function value = (ActionDefinition.Function)((Object)this.action.getValue("Function"));
            if (value != null) {
                switch (value) {
                    case APPLICATION_HEADER: 
                    case TOOLBAR: 
                    case TOOLBAR_VIEW_HEADER: {
                        color = this.applicationHeaderColor;
                        break;
                    }
                    case SECTION_HEADER: 
                    case POPUP_MENU_ITEM: {
                        color = G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE;
                        break;
                    }
                    case PRIMARY: 
                    case SUB_SECTION_HEADER: {
                        color = G5LookAndFeel.UNIVERSAL_ROBOTS_BLUE;
                        break;
                    }
                }
            }
            return color;
        }

        @Override
        protected void paintIcon(Graphics g, AbstractButton b, Rectangle iconRect) {
            ActionDefinition.Function value = (ActionDefinition.Function)((Object)this.action.getValue("Function"));
            if (value != null) {
                SwingWidgetFactory.updateIconLocation(value, b, iconRect);
                super.paintIcon(g, b, iconRect);
            }
        }

        @Override
        protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
            ActionDefinition.Function value = (ActionDefinition.Function)((Object)this.action.getValue("Function"));
            if (value != null) {
                SwingWidgetFactory.updateTextLocation(value, c, textRect);
                super.paintText(g, c, textRect, text);
            }
        }

        @Override
        protected BasicButtonListener createButtonListener(AbstractButton b) {
            return new BasicButtonListener(b){

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    super.mouseReleased(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            };
        }
    }
}

