/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.lang.ClassUtils;
import com.ur.lang.Defense;
import com.ur.swing.CardChangedListener;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.SwingUtil;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class SwitchSupport
implements FlipManager {
    private CardPanel parent;
    private final Stack<CardPanel> cardStack = new Stack();
    private final CardMap cardMap = new CardMap();
    private CardPanel currentCard;
    private final Callback callback;
    private CardPanel upcomingCard;

    public SwitchSupport(Callback callback) {
        this.callback = callback;
    }

    @Override
    public CardPanel getCurrentCard() {
        return this.currentCard;
    }

    public void setCurrentCard(CardPanel card) {
        this.currentCard = card;
    }

    @Override
    public CardPanel getCardParent() {
        return this.parent;
    }

    @Override
    public void setCardParent(CardPanel cardPanel) {
        this.parent = cardPanel;
    }

    @Override
    public void resetAll() {
        this.cardMap.resetAll();
        this.cardStack.clear();
    }

    @Override
    public boolean canReset() {
        return this.cardMap.canReset();
    }

    @Override
    public void enterActiveChild(Object o) {
        if (this.currentCard != null) {
            Log.debug((String)("Entering active child. Class=" + this.currentCard.getClass() + ". Object class=" + (o != null ? o.getClass() : "null")));
            this.currentCard.setCurrentPanel();
            this.currentCard.enter(o);
        } else {
            Log.debug((String)"Attempting enter active child, but null");
        }
    }

    @Override
    public Object exitActiveChild() {
        if (this.currentCard != null) {
            Log.debug((String)("Exiting active child. Class=" + this.currentCard.getClass()));
            return this.currentCard.exit();
        }
        Log.debug((String)"Attempting exit active child, but null");
        return null;
    }

    @Override
    public void addCardPanel(CardPanel panelInstance) {
        this.addCardPanel(panelInstance.getClass(), panelInstance);
    }

    @Override
    public void addCardPanel(Class<? extends CardPanel> panelClass, CardPanel panelInstance) {
        this.cardMap.put(panelClass, panelInstance);
    }

    @Override
    public void addCardChangedListener(CardChangedListener listener) {
        EventNotificationService.register(SwitchSupport.class, CardChangedListener.class, (Object)listener);
    }

    @Deprecated
    public void removeCardChangedListener(CardChangedListener listener) {
    }

    @Override
    public <T extends CardPanel> T getCardPanel(Class<T> c) {
        if (this.hasCardPanelForClass(c)) {
            return this.cardMap.get(c);
        }
        if (this.parent == null) {
            Log.error((String)("Could not find card: " + c.getName()));
            throw new IllegalStateException();
        }
        return this.parent.flipManager.getCardPanel(c);
    }

    public boolean hasCardPanelForClass(Class<? extends CardPanel> c) {
        return this.cardMap.weakGet(c) != null;
    }

    @Override
    public boolean switchTo(Class<? extends CardPanel> c) {
        return this.switchTo(c, null);
    }

    @Override
    public boolean switchTo(Class<? extends CardPanel> c, Object o) {
        return this.switchTo(c, o, false);
    }

    @Override
    public boolean canSwitchTo(Class<? extends CardPanel> c) {
        return this.upwardsRecursiveSearch(c);
    }

    @Override
    public boolean isParentVisible() {
        if (this.parent == null) {
            return true;
        }
        return this.parent.isVisible();
    }

    @Override
    public boolean stackCurrentCardAndSwitchTo(Class<? extends CardPanel> c) {
        return this.stackCurrentCardAndSwitchTo(c, null);
    }

    @Override
    public boolean stackCurrentCardAndSwitchTo(Class<? extends CardPanel> c, Object o) {
        return this.switchTo(c, o, true);
    }

    @Override
    public void navigateBack() {
        if (this.cardStack.empty()) {
            if (this.parent == null) {
                Log.warning((String)"cardStack is empty");
            } else {
                this.parent.flipManager.getSwitchSupport().navigateBack();
            }
        } else {
            CardPanel cp = this.cardStack.pop();
            this.callback.doNavigateBackTo(cp);
        }
    }

    @Override
    public SwitchSupport getSwitchSupport() {
        return this;
    }

    public boolean isOneOfCardsOnStack(Iterable<Class<?>> cardPanelTypes) {
        Object[] array;
        Object[] objectArray = array = this.cardStack.toArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object each = objectArray[n2];
            if (ClassUtils.isInstanceOfAny((Object)each, cardPanelTypes)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isCardStackEmpty() {
        return this.cardStack.empty();
    }

    public boolean isAllCardStacksEmpty() {
        if (this.isCardStackEmpty()) {
            return this.parent == null ? true : this.parent.flipManager.getSwitchSupport().isAllCardStacksEmpty();
        }
        return false;
    }

    public boolean hasCardPanelInStack(Class<? extends CardPanel> panel) {
        Object[] array;
        Object[] objectArray = array = this.cardStack.toArray();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object panelInStack = objectArray[n2];
            if (panel.isInstance(panelInStack)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean switchTo(Class<? extends CardPanel> c, Object o, boolean stackCurrentCard) {
        boolean result = false;
        if (this.upwardsRecursiveSwitchTo(c, o, stackCurrentCard)) {
            result = true;
        } else {
            this.logUnableToSwitchCard(c);
        }
        return SwitchSupport.notifyOfChange(c, result);
    }

    public static boolean notifyOfChange(final Class<? extends CardPanel> cardPanel, boolean success) {
        if (success) {
            EventNotificationService.notify(CardChangedListener.class, (NotificationStrategy)new NotificationStrategy<CardChangedListener>(){

                public void notify(CardChangedListener listener) {
                    listener.cardSelected(cardPanel);
                }
            });
        }
        return success;
    }

    private boolean upwardsRecursiveSwitchTo(final Class<? extends CardPanel> c, final Object o, final boolean stackCurrentCard) {
        final boolean[] returnValue = new boolean[1];
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CardPanel newCard = SwitchSupport.this.cardMap.weakGet(c);
                if (newCard != null) {
                    if (newCard != SwitchSupport.this.currentCard) {
                        if (stackCurrentCard) {
                            SwitchSupport.this.doStackCurrentCard();
                        }
                        SwitchSupport.this.upcomingCard = newCard;
                        SwitchSupport.this.exitActiveChild();
                        SwitchSupport.this.callback.afterExit(newCard, stackCurrentCard);
                        SwitchSupport.this.currentCard = newCard;
                        SwitchSupport.this.callback.beforeEnter(SwitchSupport.this.cardMap.getNameFor(c), stackCurrentCard);
                        SwitchSupport.this.enterActiveChild(o);
                    }
                    returnValue[0] = true;
                } else {
                    returnValue[0] = SwitchSupport.this.parent == null ? false : ((SwitchSupport)SwitchSupport.this).parent.flipManager.getSwitchSupport().upwardsRecursiveSwitchTo(c, o, stackCurrentCard);
                }
            }
        });
        return returnValue[0];
    }

    private boolean upwardsRecursiveSearch(final Class<? extends CardPanel> c) {
        final boolean[] returnValue = new boolean[1];
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                CardPanel newCard = SwitchSupport.this.cardMap.weakGet(c);
                returnValue[0] = newCard != null ? true : (SwitchSupport.this.parent == null ? false : ((SwitchSupport)SwitchSupport.this).parent.flipManager.getSwitchSupport().upwardsRecursiveSearch(c));
            }
        });
        return returnValue[0];
    }

    private void logUnableToSwitchCard(Class<? extends CardPanel> c) {
        String message = "Could not switch card. Unable to find card: " + c.getName() + ". ";
        if (this.currentCard != null) {
            message = String.valueOf(message) + "Currently in card: " + this.currentCard.toString() + ".";
        }
        Log.error((String)message);
    }

    private void doStackCurrentCard() {
        if (this.currentCard != null) {
            this.cardStack.push(this.currentCard);
        }
    }

    public CardPanel getUpcomingCard() {
        return this.upcomingCard;
    }

    public static interface Callback {
        public void afterExit(CardPanel var1, boolean var2);

        public void beforeEnter(String var1, boolean var2);

        public void doNavigateBackTo(CardPanel var1);
    }

    private static class CardMap {
        private final HashMap<String, CardPanel> hashMap = new HashMap();
        private final Map<Class<?>, Class<?>> actualTypeMap = new HashMap();

        private CardMap() {
        }

        public <T extends CardPanel> T get(Class<T> cardType) {
            Defense.notNull(cardType, (String)"CardType cannot be null");
            return (T)((CardPanel)cardType.cast(this.hashMap.get(cardType.getName())));
        }

        CardPanel weakGet(Class<? extends CardPanel> cardType) {
            Defense.notNull(cardType, (String)"CardType cannot be null");
            CardPanel result = this.hashMap.get(cardType.getName());
            if (result == null && this.actualTypeMap.get(cardType) != null) {
                result = this.hashMap.get(this.actualTypeMap.get(cardType).getName());
            }
            return result;
        }

        String getNameFor(Class<? extends CardPanel> c) {
            if (this.actualTypeMap.containsKey(c)) {
                return this.actualTypeMap.get(c).getName();
            }
            return c.getName();
        }

        public <T extends CardPanel> void put(Class<T> cardType, CardPanel cardPanel) {
            String originalTypeAsName = cardType.getName();
            this.hashMap.put(originalTypeAsName, cardPanel);
            this.actualTypeMap.put(cardPanel.getClass(), cardType);
        }

        public void resetAll() {
            for (CardPanel each : this.hashMap.values()) {
                each.resetAll();
            }
        }

        public boolean canReset() {
            for (CardPanel each : this.hashMap.values()) {
                if (each.canReset()) continue;
                return false;
            }
            return true;
        }
    }
}

