/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.Toggleable;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class ToggleDelegate
extends MouseAdapter {
    private final Toggleable toggleable;
    private final String constraint;
    private boolean isShown = false;

    public ToggleDelegate(Toggleable toggleable, String constraint) {
        this.toggleable = toggleable;
        this.constraint = constraint;
        JComponent replacement = toggleable.getReplacement();
        if (replacement != null) {
            replacement.addMouseListener(this);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.isShown()) {
            this.toggle();
        }
    }

    public synchronized void toggle() {
        JComponent parentPanel = this.toggleable.getParentPanel();
        JComponent panel = this.toggleable.getPanel();
        JComponent replacement = this.toggleable.getReplacement();
        if (this.isShown) {
            parentPanel.remove(panel);
            if (replacement != null) {
                parentPanel.add((Component)replacement, this.constraint);
            }
        } else {
            if (replacement != null) {
                parentPanel.remove(replacement);
            }
            parentPanel.add((Component)panel, this.constraint);
        }
        this.isShown = !this.isShown;
        this.toggleable.getRefreshCallback().refresh();
    }

    public boolean isShown() {
        return this.isShown;
    }
}

