/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;

public class URFingerDragScrollMouseListener
implements MouseMotionListener,
MouseListener {
    private Component component;
    private MouseListener[] oldMouseListeners;
    private MouseMotionListener[] oldMouseMotionListeners;
    private Point oldDragPoint = null;

    public URFingerDragScrollMouseListener(Component component) {
        this.component = component;
        this.oldMouseListeners = component.getMouseListeners();
        this.oldMouseMotionListeners = component.getMouseMotionListeners();
        int i = 0;
        while (i < this.oldMouseListeners.length) {
            component.removeMouseListener(this.oldMouseListeners[i]);
            ++i;
        }
        i = 0;
        while (i < this.oldMouseMotionListeners.length) {
            component.removeMouseMotionListener(this.oldMouseMotionListeners[i]);
            ++i;
        }
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.component.getParent() instanceof JViewport) {
            if (this.oldDragPoint == null) {
                this.oldDragPoint = e.getLocationOnScreen();
            }
            int deltaX = this.oldDragPoint.x - e.getLocationOnScreen().x;
            int deltaY = this.oldDragPoint.y - e.getLocationOnScreen().y;
            JViewport jvp = (JViewport)this.component.getParent();
            if (this.component.getParent().getParent() instanceof JScrollPane) {
                JScrollPane jsp = (JScrollPane)this.component.getParent().getParent();
                if (jsp.getHorizontalScrollBar() != null) {
                    jsp.getHorizontalScrollBar().setValue(jsp.getHorizontalScrollBar().getValue() + deltaX);
                }
                if (jsp.getVerticalScrollBar() != null) {
                    jsp.getVerticalScrollBar().setValue(jsp.getVerticalScrollBar().getValue() + deltaY);
                }
            } else {
                int newX = deltaX + jvp.getViewPosition().x;
                int newY = deltaY + jvp.getViewPosition().y;
                jvp.setViewPosition(new Point(newX, newY));
            }
            this.oldDragPoint = e.getLocationOnScreen();
        }
        int i = 0;
        while (i < this.oldMouseMotionListeners.length) {
            this.oldMouseMotionListeners[i].mouseDragged(e);
            ++i;
        }
        if (this.component instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)this.component;
            textComponent.setSelectionStart(textComponent.getSelectionEnd());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int i = 0;
        while (i < this.oldMouseMotionListeners.length) {
            this.oldMouseMotionListeners[i].mouseMoved(e);
            ++i;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        int i = 0;
        while (i < this.oldMouseListeners.length) {
            this.oldMouseListeners[i].mouseEntered(e);
            ++i;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        int i = 0;
        while (i < this.oldMouseListeners.length) {
            this.oldMouseListeners[i].mouseExited(e);
            ++i;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int i = 0;
        while (i < this.oldMouseListeners.length) {
            this.oldMouseListeners[i].mouseClicked(e);
            ++i;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.oldDragPoint = e.getLocationOnScreen();
        int i = 0;
        while (i < this.oldMouseListeners.length) {
            this.oldMouseListeners[i].mousePressed(e);
            ++i;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int i = 0;
        while (i < this.oldMouseListeners.length) {
            this.oldMouseListeners[i].mouseReleased(e);
            ++i;
        }
    }
}

