/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import java.awt.Font;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.FontUIResource;

public interface URFontFactory {
    public Font getDefaultFont();

    public FontUIResource getDefaultFontResource();

    public Font getFont(Typeface var1);

    public Font getRelativeFont(Style var1);

    public Font getRelativeFont(Size var1);

    public Font getRelativeFont(Typeface var1, Style var2);

    public Font getRelativeFont(Typeface var1, Size var2);

    public Font getRelativeFont(Style var1, Size var2);

    public Font getRelativeFont(Typeface var1, Style var2, Size var3);

    public Font getBestFitFont(JComponent var1, int var2, String var3, Size ... var4);

    public static enum Size {
        TINY,
        VERY_SMALL,
        SMALL,
        DEFAULT,
        MEDIUM,
        LARGE,
        VERY_LARGE,
        MAIN_HEADING_SIZE,
        HUGE;

    }

    public static enum Style {
        DEFAULT,
        BOLD,
        ITALIC,
        BOLD_ITALIC;

    }

    public static abstract class Template
    implements URFontFactory {
        protected static boolean isMac = System.getProperty("os.name").contains("Mac");

        @Override
        public Font getDefaultFont() {
            return this.getRelativeFont(Typeface.DEFAULT, Style.DEFAULT, Size.DEFAULT);
        }

        @Override
        public FontUIResource getDefaultFontResource() {
            return new FontUIResource(this.getDefaultFont());
        }

        @Override
        public Font getFont(Typeface typeface) {
            return this.getRelativeFont(typeface, Style.DEFAULT, Size.DEFAULT);
        }

        @Override
        public Font getRelativeFont(Style style) {
            return this.getRelativeFont(Typeface.DEFAULT, style, Size.DEFAULT);
        }

        @Override
        public Font getRelativeFont(Size size) {
            return this.getRelativeFont(Typeface.DEFAULT, Style.DEFAULT, size);
        }

        @Override
        public Font getRelativeFont(Typeface typeface, Style style) {
            return this.getRelativeFont(typeface, style, Size.DEFAULT);
        }

        @Override
        public Font getRelativeFont(Typeface typeface, Size size) {
            return this.getRelativeFont(typeface, Style.DEFAULT, size);
        }

        @Override
        public Font getRelativeFont(Style style, Size size) {
            return this.getRelativeFont(Typeface.DEFAULT, style, size);
        }

        @Override
        public Font getBestFitFont(JComponent component, int maxTextWidth, String text, Size ... givenSizes) {
            Font lastFont = component.getFont();
            Size[] sizeArray = givenSizes;
            int n = givenSizes.length;
            int n2 = 0;
            while (n2 < n) {
                Size fontSize;
                lastFont = this.getRelativeFont(component instanceof AbstractButton ? Style.BOLD : Style.DEFAULT, fontSize = sizeArray[n2]);
                int textWidth = component.getFontMetrics(lastFont).stringWidth(text);
                if (textWidth <= maxTextWidth) break;
                ++n2;
            }
            return lastFont;
        }
    }

    public static enum Typeface {
        DEFAULT,
        SERIF,
        SANS_SERIF,
        MONOSPACED;

    }
}

