/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.BorderEnabler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;

public class UnitLabelBorder
extends MatteBorder {
    private String unitText;
    private Font font;

    public UnitLabelBorder(String text, Font font) {
        this(text, font, UIManager.getInt("Unit.size"));
    }

    public UnitLabelBorder(String text, Font font, int width) {
        super(0, 0, 0, width, UIManager.getColor("Panel.background"));
        this.unitText = text;
        this.font = font;
    }

    public void setUnit(String text) {
        this.unitText = text;
    }

    public String getUnit() {
        return this.unitText;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        super.paintBorder(c, g, x, y, width, height);
        Color color = this.getBorderColor(c);
        g.setColor(color);
        Font oldFont = g.getFont();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(this.font);
        g.drawString(this.unitText, x + width - (this.right - 5), y + 5 + this.font.getSize());
        g.setFont(oldFont);
    }

    private Color getBorderColor(Component c) {
        if (c instanceof BorderEnabler) {
            BorderEnabler borderEnabler = (BorderEnabler)((Object)c);
            if (borderEnabler.isBorderEnabled()) {
                return Color.BLACK;
            }
            return Color.LIGHT_GRAY;
        }
        if (c.isEnabled()) {
            return Color.BLACK;
        }
        return Color.LIGHT_GRAY;
    }
}

