/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing;

import com.ur.swing.RenderingStrategy;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboPopup;

public class WideDropDownRenderer
implements PopupMenuListener {
    private final RenderingStrategy renderingStrategy;
    private final int iconTextGap = new JLabel().getIconTextGap();
    private final int maxPopupWidth;
    private final boolean openAbove;

    public WideDropDownRenderer(RenderingStrategy renderingStrategy, int maxPopupWidth) {
        this(renderingStrategy, maxPopupWidth, false);
    }

    public WideDropDownRenderer(RenderingStrategy renderingStrategy, int maxPopupWidth, boolean openAbove) {
        this.renderingStrategy = renderingStrategy;
        this.maxPopupWidth = maxPopupWidth;
        this.openAbove = openAbove;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        if (!(e.getSource() instanceof JComboBox)) {
            return;
        }
        final JComboBox comboBox = (JComboBox)e.getSource();
        if (!(comboBox.getAccessibleContext().getAccessibleChild(0) instanceof BasicComboPopup)) {
            return;
        }
        final BasicComboPopup popup = (BasicComboPopup)comboBox.getAccessibleContext().getAccessibleChild(0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WideDropDownRenderer.this.resizeDropDown(popup, comboBox);
            }
        });
    }

    private void resizeDropDown(BasicComboPopup popup, JComboBox comboBox) {
        JScrollPane scrollPane = this.getScrollPane(popup);
        if (scrollPane == null) {
            return;
        }
        Dimension size = scrollPane.getPreferredSize();
        int verticalScrollBarWidth = scrollPane.getVerticalScrollBar() == null ? 0 : scrollPane.getVerticalScrollBar().getSize().width;
        int borderWidth = this.getBorderWidth(popup);
        int maxItemWidth = Math.max(this.computeMaxItemWidth(comboBox) + borderWidth + verticalScrollBarWidth, size.width);
        size.width = Math.min(maxItemWidth, this.maxPopupWidth);
        scrollPane.setPreferredSize(size);
        scrollPane.setMaximumSize(size);
        Point locationOnScreen = comboBox.getLocationOnScreen();
        if (this.openAbove) {
            int height = popup.getPreferredSize().height;
            popup.setLocation(locationOnScreen.x, locationOnScreen.y - height);
        } else {
            int height = comboBox.getPreferredSize().height;
            locationOnScreen.y += height - 1;
            popup.setLocation(locationOnScreen);
        }
    }

    private JScrollPane getScrollPane(BasicComboPopup popup) {
        JList<Object> list = popup.getList();
        Container c = SwingUtilities.getAncestorOfClass(JScrollPane.class, list);
        return c instanceof JScrollPane ? (JScrollPane)c : null;
    }

    private int getBorderWidth(BasicComboPopup popup) {
        Border border = popup.getBorder();
        Insets borderInsets = border.getBorderInsets(popup);
        return borderInsets.left + borderInsets.right;
    }

    private int computeMaxItemWidth(JComboBox comboBox) {
        BasicComboPopup popup = (BasicComboPopup)comboBox.getAccessibleContext().getAccessibleChild(0);
        int numOfItems = comboBox.getItemCount();
        int widest = 0;
        int i = 0;
        while (i < numOfItems) {
            Object item = comboBox.getItemAt(i);
            String text = this.renderingStrategy.getText(item);
            Icon icon = this.renderingStrategy.getIcon(item);
            int iconWidth = icon != null ? icon.getIconWidth() + this.iconTextGap : 0;
            Font font = popup.getList().getAccessibleContext().getAccessibleChild(i).getAccessibleContext().getAccessibleComponent().getFont();
            FontMetrics metrics = comboBox.getFontMetrics(font);
            int lineWidth = metrics.stringWidth(text) + iconWidth;
            widest = Math.max(widest, lineWidth);
            ++i;
        }
        return widest;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

