/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.aspects.interception;

import com.ur.swing.SwingUtil;
import com.ur.swing.aspects.UIInvokeLater;
import com.ur.swing.aspects.interception.InterceptionUtils;
import com.ur.util.logging.Log;
import java.util.concurrent.Callable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class UIThreadInterceptor
implements MethodInterceptor {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ UIThreadInterceptor ajc$perSingletonInstance;

    @Around(value="execution(@(com.ur.swing.aspects.UIInvokeAndWait || com.ur.swing.aspects.UIInvokeLater) * *.*(..))")
    public Object aroundAnnotatedMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        return InterceptionUtils.intercept(joinPoint, this);
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (methodInvocation.getMethod().isAnnotationPresent(UIInvokeLater.class)) {
            SwingUtil.invokeLater(new InvokeAndReturnCallable(methodInvocation));
            return null;
        }
        if (SwingUtil.isUiOrEventThread()) {
            return this.tryThisThreadPerformInvoke(methodInvocation);
        }
        return this.tryInvokeOnNewThread(methodInvocation);
    }

    private Object tryThisThreadPerformInvoke(MethodInvocation methodInvocation) throws SwingInvocationException {
        try {
            return methodInvocation.proceed();
        }
        catch (Throwable e) {
            Log.error((String)("Failed to execute " + Thread.currentThread().getName() + "\n" + methodInvocation), (Throwable)e);
            throw new SwingInvocationException(e);
        }
    }

    private Object tryInvokeOnNewThread(MethodInvocation methodInvocation) {
        try {
            InvokeAndReturnCallable callable = new InvokeAndReturnCallable(methodInvocation);
            return SwingUtil.invokeAndWaitForAnswer(callable);
        }
        catch (Exception e) {
            throw new SwingUtil.InvocationWasInterrupted(e);
        }
    }

    public static UIThreadInterceptor aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.ur.swing.aspects.interception.UIThreadInterceptor", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            UIThreadInterceptor.ajc$perSingletonInstance = new UIThreadInterceptor();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    private final class InvokeAndReturnCallable
    implements Callable<Object> {
        private final String threadName = Thread.currentThread().getName();
        private final MethodInvocation methodInvocation;

        private InvokeAndReturnCallable(MethodInvocation methodInvocation) {
            this.methodInvocation = methodInvocation;
        }

        @Override
        public Object call() throws Exception {
            try {
                return this.methodInvocation.proceed();
            }
            catch (Throwable e) {
                Log.error((String)("Failed to execute from " + Thread.currentThread().getName()), (Throwable)e);
                throw new SwingInvocationException(e);
            }
        }
    }

    public class SwingInvocationException
    extends Exception {
        public SwingInvocationException(Throwable e) {
            super("Failed invocation", e);
        }
    }
}

