/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.baseview;

import com.ur.swing.baseview.AccordionMenuAddedListener;
import com.ur.swing.baseview.AccordionMenuHeader;
import com.ur.swing.baseview.AccordionMenuItem;
import com.ur.swing.baseview.AccordionView;
import com.ur.swing.extensible.MenuExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Action;

public class AccordionMenuBuilder<T extends Enum<T>> {
    private final AccordionMenuHeader<T> headers;
    private final AccordionMenuItem<T> items;
    private AccordionView accordionView;
    private AccordionMenuAddedListener headerModifiedListener;
    private AccordionMenuAddedListener itemModifiedListener;
    private final Map<T, AbstractButton> categoryMap = new HashMap<T, AbstractButton>();
    private final Map<T, Action> actionMap = new HashMap<T, Action>();
    private final T data;

    @Inject
    public AccordionMenuBuilder(AccordionMenuHeader<T> headers, AccordionMenuItem<T> items, T dataItem) {
        this.headers = headers;
        this.items = items;
        this.data = dataItem;
        this.headers.setOnAddedListener(new HeaderAdded());
        this.items.setOnAddedListener(new ItemsAdded());
    }

    public void setNavigationMenu(AccordionView accordionView) {
        this.accordionView = accordionView;
    }

    public void setHeaderAddedListener(AccordionMenuAddedListener modifiedListener) {
        this.headerModifiedListener = modifiedListener;
    }

    public void setItemAddedListener(AccordionMenuAddedListener modifiedListener) {
        this.itemModifiedListener = modifiedListener;
    }

    protected void rebuildAllMenus() {
        Enum each;
        Enum[] enumArray = (Enum[])((Enum)this.data).getDeclaringClass().getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            each = enumArray[n2];
            this.accordionView.removeSection(this.categoryMap.get(each));
            ++n2;
        }
        enumArray = (Enum[])((Enum)this.data).getDeclaringClass().getEnumConstants();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            each = enumArray[n2];
            this.categoryMap.put(each, this.rebuildContributionMenu(this.items.getContributions(each), this.actionMap.get(each)));
            ++n2;
        }
    }

    protected AbstractButton rebuildContributionMenu(List<MenuExtension.EnumMenuContribution<T>> menuContributionList, Action sectionAction) {
        if (sectionAction == null || menuContributionList == null) {
            return null;
        }
        Collections.sort(menuContributionList, new Comparator<MenuExtension.EnumMenuContribution<T>>(){

            @Override
            public int compare(MenuExtension.EnumMenuContribution<T> o1, MenuExtension.EnumMenuContribution<T> o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        ArrayList<Action> actions = new ArrayList<Action>();
        for (MenuExtension.EnumMenuContribution<T> each : menuContributionList) {
            actions.add(each.contribution);
        }
        return this.accordionView.addSection(sectionAction, actions.toArray(new Action[0]));
    }

    private class HeaderAdded
    implements AccordionMenuAddedListener<T> {
        private HeaderAdded() {
        }

        @Override
        public void onAdded(MenuExtension.EnumMenuContribution<T> contribution) {
            AccordionMenuBuilder.this.actionMap.put(contribution.getMenuCategory(), contribution.contribution);
            AccordionMenuBuilder.this.rebuildAllMenus();
            this.notifyListeners(contribution);
        }

        private void notifyListeners(MenuExtension.EnumMenuContribution<T> contribution) {
            if (AccordionMenuBuilder.this.headerModifiedListener != null) {
                AccordionMenuBuilder.this.headerModifiedListener.onAdded(contribution);
            }
        }
    }

    private class ItemsAdded
    implements AccordionMenuAddedListener<T> {
        private ItemsAdded() {
        }

        @Override
        public void onAdded(MenuExtension.EnumMenuContribution<T> contribution) {
            AccordionMenuBuilder.this.rebuildAllMenus();
            this.notifyListeners(contribution);
        }

        private void notifyListeners(MenuExtension.EnumMenuContribution<T> contribution) {
            if (AccordionMenuBuilder.this.itemModifiedListener != null) {
                AccordionMenuBuilder.this.itemModifiedListener.onAdded(contribution);
            }
        }
    }
}

